/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.math;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class VectorHelper {
    public static Vector3d rotateAroundX(Vector3d vector, double angle) {
        double y = Math.cos(angle) * vector.field_72448_b - Math.sin(angle) * vector.field_72449_c;
        double z = Math.sin(angle) * vector.field_72448_b + Math.cos(angle) * vector.field_72449_c;
        vector = new Vector3d(vector.field_72450_a, y, z);
        return vector;
    }

    public static Vector3d rotateAroundY(Vector3d vector, double angle) {
        double x = Math.cos(angle) * vector.field_72450_a + Math.sin(angle) * vector.field_72449_c;
        double z = -Math.sin(angle) * vector.field_72450_a + Math.cos(angle) * vector.field_72449_c;
        vector = new Vector3d(x, vector.field_72448_b, z);
        return vector;
    }

    public static Vector3d rotateAroundZ(Vector3d vector, double angle) {
        double x = Math.cos(angle) * vector.field_72450_a - Math.sin(angle) * vector.field_72448_b;
        double y = Math.sin(angle) * vector.field_72450_a + Math.cos(angle) * vector.field_72448_b;
        vector = new Vector3d(x, y, vector.field_72449_c);
        return vector;
    }

    public static Vector3d calculateViewVectorFromBodyRot(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static Vector3d calculateRotationBasedOffsetPosition(Vector3d position, double angdeg, double offsetX, double offsetY, double offsetZ) {
        double yRotInRadians = Math.toRadians(angdeg);
        double xOffset = Math.sin(yRotInRadians) * offsetX;
        double zOffset = Math.cos(yRotInRadians) * offsetX;
        double xPos = position.func_82615_a() - zOffset - Math.cos(yRotInRadians - 1.5707963267948966) * offsetZ;
        double yPos = position.func_82617_b() + offsetY;
        double zPos = position.func_82616_c() - xOffset - Math.sin(yRotInRadians - 1.5707963267948966) * offsetZ;
        return new Vector3d(xPos, yPos, zPos);
    }

    public static Vector3d calculateViewVectorFromYaw(float yRot) {
        double f = (double)(-yRot) * Math.PI / 180.0;
        double f1 = Math.sin(f);
        double f2 = Math.cos(f);
        return new Vector3d(f1, 0.0, f2);
    }
}

