/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.poi;

import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.poi.POIEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.data.world.NPCWorldData;

public class NTEventTarget
extends POIEventTarget {
    private TrackedNPC tracked;

    public NTEventTarget() {
    }

    public NTEventTarget(ServerWorld world, Vector3d pos, long openTime, TrackedNPC tracked) {
        super(world, pos, openTime);
        this.setTracked(tracked);
    }

    private void setTracked(TrackedNPC tracked) {
        this.tracked = tracked;
        this.setTriggerAction((world, poi) -> this.tracked.spawnTrackedMob(world, poi.getPosition()));
    }

    @Override
    public CompoundNBT save() {
        CompoundNBT tag = super.save();
        tag.func_74772_a("trackedId", this.tracked.getId());
        return tag;
    }

    @Override
    public void load(CompoundNBT tag) {
        super.load(tag);
        long id = tag.func_74763_f("trackedId");
        Optional<TrackedNPC> tracked = NPCWorldData.get().getTrackedMob(id);
        if (tracked.isPresent()) {
            this.setTracked(tracked.get());
        }
    }

    public TrackedNPC getTrackedNPC() {
        return this.tracked;
    }
}

