/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.poi;

import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class POIEventTarget {
    private ServerWorld level;
    private Vector3d pos;
    private long startTime;
    private long openTime;
    private EventTriggerAction triggerAction;

    public POIEventTarget() {
    }

    public POIEventTarget(ServerWorld level, Vector3d pos, long openTime) {
        this.level = level;
        this.pos = pos;
        this.startTime = level.func_82737_E();
        this.openTime = openTime;
    }

    public ServerWorld getLevel() {
        return this.level;
    }

    public Vector3d getPosition() {
        return this.pos;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean shouldTrigger(ServerPlayerEntity player) {
        return this.getTriggerAction() != null && player.func_195048_a(this.getPosition()) < 10000.0;
    }

    @Nullable
    public EventTriggerAction getTriggerAction() {
        return this.triggerAction;
    }

    public void setTriggerAction(EventTriggerAction event) {
        this.triggerAction = event;
    }

    public boolean hasExpired(ServerWorld world) {
        return world.func_82737_E() > this.startTime + this.openTime;
    }

    public void tick() {
    }

    public CompoundNBT save() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("x", this.pos.field_72450_a);
        tag.func_74780_a("y", this.pos.field_72448_b);
        tag.func_74780_a("z", this.pos.field_72449_c);
        tag.func_74772_a("startTime", this.startTime);
        tag.func_74772_a("openTime", this.openTime);
        return tag;
    }

    public void load(CompoundNBT tag) {
        Vector3d pos;
        double x = tag.func_74769_h("x");
        double y = tag.func_74769_h("y");
        double z = tag.func_74769_h("z");
        this.pos = pos = new Vector3d(x, y, z);
        this.startTime = tag.func_74763_f("startTime");
        this.openTime = tag.func_74763_f("openTime");
    }

    @FunctionalInterface
    public static interface EventTriggerAction {
        public void trigger(ServerWorld var1, POIEventTarget var2);
    }
}

