/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.util;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;

public class TargetsPredicate {
    public static final TargetsPredicate EVERYTHING = new TargetsPredicate().selector((Predicate<LivingEntity>)Predicates.alwaysTrue());
    public static final TargetsPredicate DEFAULT_AREA_CHECK = new TargetsPredicate().testEnemyFaction();
    public static final TargetsPredicate DEFAULT_LINE_CHECK = new TargetsPredicate().testEnemyFaction().testAdvancedInView();
    private EntityPredicate vanillaPredicate = EntityPredicate.field_221016_a;
    private boolean testSimpleInView;
    private boolean testAdvancedInView;
    private float fov;
    private boolean testEnemy;
    private boolean testFriendly;
    private Predicate<LivingEntity> selector;

    public TargetsPredicate testVanilla(EntityPredicate entityPredicate) {
        this.vanillaPredicate = entityPredicate;
        return this;
    }

    public TargetsPredicate testSimpleInView() {
        this.testSimpleInView = true;
        return this;
    }

    public TargetsPredicate testAdvancedInView() {
        this.testAdvancedInView = true;
        this.fov = 60.0f;
        return this;
    }

    public TargetsPredicate testAdvancedInView(float fov) {
        this.testAdvancedInView = true;
        this.fov = fov;
        return this;
    }

    public TargetsPredicate testEnemyFaction() {
        this.testEnemy = true;
        return this;
    }

    public TargetsPredicate testFriendlyFaction() {
        this.testFriendly = true;
        return this;
    }

    public TargetsPredicate selector(@Nullable Predicate<LivingEntity> customPredicate) {
        this.selector = customPredicate;
        return this;
    }

    public boolean test(@Nullable LivingEntity entity, LivingEntity target) {
        if (!this.vanillaPredicate.func_221015_a(entity, target)) {
            return false;
        }
        if (this.selector != null && !this.selector.test(target)) {
            return false;
        }
        if (this.testEnemy && !ModEntityPredicates.getEnemyFactions(entity).test((Entity)target)) {
            return false;
        }
        if (this.testFriendly && !ModEntityPredicates.getFriendlyFactions(entity).test((Entity)target)) {
            return false;
        }
        if (this.testSimpleInView && !entity.func_70685_l((Entity)target)) {
            return false;
        }
        return !this.testAdvancedInView || entity.func_70685_l((Entity)target) && TargetHelper.isEntityInView(entity, (Entity)target, this.fov);
    }
}

