/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.BlockQueue;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.ChallengesHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.BlockPilePart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SimpleBasePart;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BaratieSimpleArena
extends ChallengeArena {
    public static final BaratieSimpleArena INSTANCE = new BaratieSimpleArena();
    private static final int ARENA_XZ_SIZE_RADIUS = 70;
    private static final int ARENA_Y_SIZE_RADIUS = 50;
    private static final int ARENA_XZ_SIZE = 140;
    private static final int GROUND_LEVEL = 30;

    private BaratieSimpleArena() {
        super(ArenaStyle.SIMPLE);
    }

    @Override
    public void buildArena(InProgressChallenge challenge, BlockQueue queue) {
        int bottomLayerOffset = 49;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        BlockPos groundLayer = bottomLayer.func_177981_b(30);
        BlockPos neCorner = groundLayer.func_177982_a(15, 0, -15);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(3); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            BlockPos pos = neCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            pile.buildPart(challenge.getShard(), pos, queue);
        }
        BlockPos nCorner = groundLayer.func_177982_a(0, 0, -20);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(2); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 5);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 5);
            BlockPos pos = nCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            pile.buildPart(challenge.getShard(), pos, queue);
        }
        BlockPos eCorner = groundLayer.func_177982_a(20, 0, 0);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(2); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            BlockPos pos = eCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            pile.buildPart(challenge.getShard(), pos, queue);
        }
        BlockPos sCorner = groundLayer.func_177982_a(0, 0, 20);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(1); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 10);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 5);
            BlockPos pos = sCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            pile.buildPart(challenge.getShard(), pos, queue);
        }
        BlockPos swCorner = groundLayer.func_177982_a(-15, 0, 15);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(2); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 10);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            BlockPos pos = swCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            pile.buildPart(challenge.getShard(), pos, queue);
        }
        BlockPos wCorner = groundLayer.func_177982_a(-20, 0, 0);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(2); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 10);
            BlockPos pos = wCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            pile.buildPart(challenge.getShard(), pos, queue);
        }
        StructuresHelper.calcCenteredFilledCircle((World)challenge.getShard(), groundLayer.func_177977_b(), 40, 2, Blocks.field_196662_n.func_176223_P(), queue);
        StructuresHelper.calcCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 140, 2, 140, Blocks.field_150354_m.func_176223_P(), queue);
        StructuresHelper.calcCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 139, 30, 139, Blocks.field_150355_j.func_176223_P(), queue);
        new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos(), queue);
    }

    @Override
    public Set<BlockPos> buildArena(InProgressChallenge challenge) {
        HashSet blocks = Sets.newHashSet();
        int bottomLayerOffset = 49;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        BlockPos groundLayer = bottomLayer.func_177981_b(30);
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 139, 30, 139, Blocks.field_150355_j.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), groundLayer.func_177977_b(), 40, 2, Blocks.field_196662_n.func_176223_P(), 0, null));
        BlockPos neCorner = groundLayer.func_177982_a(15, 0, -15);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(3); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            BlockPos pos = neCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            blocks.addAll(pile.buildPart(challenge.getShard(), pos));
        }
        BlockPos nCorner = groundLayer.func_177982_a(0, 0, -20);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(2); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 5);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 5);
            BlockPos pos = nCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            blocks.addAll(pile.buildPart(challenge.getShard(), pos));
        }
        BlockPos eCorner = groundLayer.func_177982_a(20, 0, 0);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(2); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            BlockPos pos = eCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            blocks.addAll(pile.buildPart(challenge.getShard(), pos));
        }
        BlockPos sCorner = groundLayer.func_177982_a(0, 0, 20);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(1); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 10);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 5);
            BlockPos pos = sCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            blocks.addAll(pile.buildPart(challenge.getShard(), pos));
        }
        BlockPos swCorner = groundLayer.func_177982_a(-15, 0, 15);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(2); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 10);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            BlockPos pos = swCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            blocks.addAll(pile.buildPart(challenge.getShard(), pos));
        }
        BlockPos wCorner = groundLayer.func_177982_a(-20, 0, 0);
        for (int i = 0; i < 1 + challenge.getRNG().nextInt(2); ++i) {
            int xoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -5, 5);
            int zoffset = (int)WyHelper.randomWithRange(challenge.getRNG(), -10, 10);
            BlockPos pos = wCorner.func_177982_a(xoffset, 1, zoffset);
            BlockPilePart pile = new BlockPilePart(challenge, ((Block)ModBlocks.DESIGN_BARREL.get()).func_176223_P());
            pile.setChangeFunc(state -> (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.func_239631_a_((Random)challenge.getRNG())));
            blocks.addAll(pile.buildPart(challenge.getShard(), pos));
        }
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 140, 2, 140, Blocks.field_150354_m.func_176223_P(), 0, null));
        blocks.addAll(new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos()));
        return blocks;
    }

    @Override
    public MutableBoundingBox getArenaLimits() {
        return new MutableBoundingBox(-70, -50, -70, 70, 50, 70);
    }

    public static ChallengeArena.SpawnPosition getChallengerSpawnPos(int posId, InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() - 20 - (posId + 1), challenge.getArenaPos().func_177956_o() - 16, challenge.getArenaPos().func_177952_p() - 20);
        return new ChallengeArena.SpawnPosition(pos, -45.0f, 0.0f);
    }

    public static ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() + 20, challenge.getArenaPos().func_177956_o() - 16, challenge.getArenaPos().func_177952_p() + 20);
        return ChallengesHelper.get4DefaultSpawnPoints(pos, 140.0f);
    }
}

