/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.BlockQueue;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.ChallengesHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SimpleBasePart;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class CircusArena
extends ChallengeArena {
    public static final CircusArena INSTANCE = new CircusArena();
    private static final int ARENA_SIZE_RADIUS = 30;
    private static final int ARENA_SIZE = 60;
    private static final BlockProtectionRule CIRCUS_TENT_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[0]).addReplaceRules((world, pos, oldState) -> {
        int id = (Math.abs(pos.func_177958_n()) + Math.abs(pos.func_177952_p())) % 3;
        if (id == 0) {
            world.func_175656_a(pos, Blocks.field_196557_aM.func_176223_P());
        } else if (id == 1) {
            world.func_175656_a(pos, Blocks.field_196570_aZ.func_176223_P());
        } else {
            world.func_175656_a(pos, Blocks.field_196556_aL.func_176223_P());
        }
        return true;
    }).build();
    private static final Function<BlockPos, BlockState> CIRCUS_TENT_FUNC = pos -> {
        int id = (Math.abs(pos.func_177958_n()) + Math.abs(pos.func_177952_p())) % 3;
        if (id == 0) {
            return Blocks.field_196557_aM.func_176223_P();
        }
        if (id == 1) {
            return Blocks.field_196570_aZ.func_176223_P();
        }
        return Blocks.field_196556_aL.func_176223_P();
    };

    private CircusArena() {
        super(ArenaStyle.SIMPLE);
    }

    @Override
    public void buildArena(InProgressChallenge challenge, BlockQueue queue) {
        int bottomLayerOffset = 29;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(29);
        BlockPos groundLayer = bottomLayer.func_177981_b(18);
        StructuresHelper.calcCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177981_b(17), 60, 1, 60, Blocks.field_150354_m.func_176223_P(), queue);
        StructuresHelper.calcCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 60, 17, 60, Blocks.field_150348_b.func_176223_P(), queue);
        StructuresHelper.calcHollowSphere((World)challenge.getShard(), bottomLayer.func_177981_b(15), 30, 30, 3, CIRCUS_TENT_FUNC, queue);
        StructuresHelper.calcCenteredFilledCube((World)challenge.getShard(), challenge.getArenaPos().func_177979_c(11), 60, 10, 60, ((Block)ModBlocks.CHALLENGE_AIR.get()).func_176223_P(), queue);
        new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos(), queue);
    }

    @Override
    public Set<BlockPos> buildArena(InProgressChallenge challenge) {
        HashSet blocks = Sets.newHashSet();
        int bottomLayerOffset = 29;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(29);
        BlockPos groundLayer = bottomLayer.func_177981_b(18);
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), challenge.getArenaPos().func_177979_c(11), 60, 10, 60, ((Block)ModBlocks.CHALLENGE_AIR.get()).func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createHollowSphere((World)challenge.getShard(), bottomLayer.func_177981_b(15), 30, 30, 3, Blocks.field_196557_aM.func_176223_P(), 0, CIRCUS_TENT_RULE));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 60, 17, 60, Blocks.field_150348_b.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177981_b(17), 60, 1, 60, Blocks.field_150354_m.func_176223_P(), 0, null));
        blocks.addAll(new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos()));
        return blocks;
    }

    @Override
    public MutableBoundingBox getArenaLimits() {
        return new MutableBoundingBox(-30, -30, -30, 31, 30, 31);
    }

    public static ChallengeArena.SpawnPosition getChallengerSpawnPos(int posId, InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() + 15 - (posId + 1), challenge.getArenaPos().func_177956_o() - 10, challenge.getArenaPos().func_177952_p() + 15);
        return new ChallengeArena.SpawnPosition(pos, 135.0f, 0.0f);
    }

    public static ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() - 15, challenge.getArenaPos().func_177956_o() - 10, challenge.getArenaPos().func_177952_p() - 15);
        return ChallengesHelper.get4DefaultSpawnPoints(pos, 140.0f);
    }
}

