/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.BlockQueue;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.ChallengesHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.blocks.PoneglyphBlock;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class PoneglyphLowspecArena
extends ChallengeArena {
    public static final PoneglyphLowspecArena INSTANCE = new PoneglyphLowspecArena();
    private static final int ARENA_XZ_SIZE_RADIUS = 50;
    private static final int ARENA_Y_SIZE_RADIUS = 50;
    private final WeightedList<BlockState> list = new WeightedList(new Object[0]);

    private PoneglyphLowspecArena() {
        super(ArenaStyle.LOWSPEC);
    }

    @Override
    public void buildArena(InProgressChallenge challenge, BlockQueue queue) {
        boolean isUlti = challenge.isUltimateDifficulty();
        this.list.clear();
        this.list.addEntry((BlockState)((Block)ModBlocks.PONEGLYPH.get()).func_176223_P().func_206870_a((Property)PoneglyphBlock.TEXTURE, (Comparable)Integer.valueOf(0)), 100.0f);
        this.list.addEntry((BlockState)((Block)ModBlocks.PONEGLYPH.get()).func_176223_P().func_206870_a((Property)PoneglyphBlock.TEXTURE, (Comparable)Integer.valueOf(1)), 100.0f);
        this.list.addEntry((BlockState)((Block)ModBlocks.PONEGLYPH.get()).func_176223_P().func_206870_a((Property)PoneglyphBlock.TEXTURE, (Comparable)Integer.valueOf(2)), 100.0f);
        int bottomLayerOffset = 49;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        StructuresHelper.calcCenteredFilledCircle((World)challenge.getShard(), bottomLayer, 50, 1, this.list, queue);
        StructuresHelper.calcHollowSphere((World)challenge.getShard(), bottomLayer, 50, 50, 2, Blocks.field_180401_cv.func_176223_P(), queue);
    }

    @Override
    public Set<BlockPos> buildArena(InProgressChallenge challenge) {
        HashSet blocks = Sets.newHashSet();
        boolean isUlti = challenge.isUltimateDifficulty();
        this.list.clear();
        this.list.addEntry((BlockState)((Block)ModBlocks.PONEGLYPH.get()).func_176223_P().func_206870_a((Property)PoneglyphBlock.TEXTURE, (Comparable)Integer.valueOf(0)), 100.0f);
        this.list.addEntry((BlockState)((Block)ModBlocks.PONEGLYPH.get()).func_176223_P().func_206870_a((Property)PoneglyphBlock.TEXTURE, (Comparable)Integer.valueOf(1)), 100.0f);
        this.list.addEntry((BlockState)((Block)ModBlocks.PONEGLYPH.get()).func_176223_P().func_206870_a((Property)PoneglyphBlock.TEXTURE, (Comparable)Integer.valueOf(2)), 100.0f);
        int bottomLayerOffset = 49;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), bottomLayer, 50, 1, this.list, 0, null));
        blocks.addAll(StructuresHelper.createHollowSphere((World)challenge.getShard(), bottomLayer, 50, 50, 2, Blocks.field_180401_cv.func_176223_P(), 0, null));
        return blocks;
    }

    @Override
    public MutableBoundingBox getArenaLimits() {
        return new MutableBoundingBox(-50, -50, -50, 50, 50, 50);
    }

    public static ChallengeArena.SpawnPosition getChallengerSpawnPos(int posId, InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() - 30 - (posId + 1), challenge.getArenaPos().func_177956_o() - 45, challenge.getArenaPos().func_177952_p());
        return new ChallengeArena.SpawnPosition(pos, -90.0f, 23.0f);
    }

    public static ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() + 30, challenge.getArenaPos().func_177956_o() - 45, challenge.getArenaPos().func_177952_p());
        return ChallengesHelper.get4DefaultSpawnPoints(pos, 180.0f);
    }
}

