/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas.parts;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.BlockQueue;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaPart;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.BrokenSandstonePillarPart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.LargeSandPilePart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SandstonePillarPart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SmallSandPilePart;

public class AlabastaDesertDetailsPart
extends ArenaPart {
    private final int arenaSizeRadius;

    public AlabastaDesertDetailsPart(InProgressChallenge challenge, int arenaSizeRadius) {
        super(challenge);
        this.arenaSizeRadius = arenaSizeRadius;
    }

    @Override
    public void buildPart(ServerWorld world, BlockPos spawnPos, BlockQueue queue) {
        BlockPos nwCorner = spawnPos.func_177985_f(this.arenaSizeRadius / 2).func_177964_d(this.arenaSizeRadius / 2);
        BlockPos neCorner = spawnPos.func_177965_g(this.arenaSizeRadius / 4).func_177964_d(this.arenaSizeRadius / 4);
        BlockPos seCorner = spawnPos.func_177965_g(this.arenaSizeRadius / 2).func_177970_e(this.arenaSizeRadius / 2);
        BlockPos swCorner = spawnPos.func_177985_f(this.arenaSizeRadius / 4).func_177970_e(this.arenaSizeRadius / 2);
        boolean nwCornerAlt = this.getRNG().nextBoolean();
        boolean neCornerAlt = this.getRNG().nextBoolean();
        boolean swCornerAlt = this.getRNG().nextBoolean();
        boolean seCornerAlt = this.getRNG().nextBoolean();
        if (nwCornerAlt) {
            new SandstonePillarPart(this.getChallenge()).buildPart(world, nwCorner, queue);
            new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, nwCorner.func_177965_g(11), queue);
            new SandstonePillarPart(this.getChallenge()).buildPart(world, nwCorner.func_177965_g(7).func_177964_d(7), queue);
        } else {
            new LargeSandPilePart(this.getChallenge()).buildPart(world, nwCorner.func_177964_d(5), queue);
            new LargeSandPilePart(this.getChallenge()).buildPart(world, nwCorner.func_177965_g(21), queue);
            new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, nwCorner.func_177965_g(2).func_177970_e(10), queue);
        }
        if (seCornerAlt) {
            new SandstonePillarPart(this.getChallenge()).buildPart(world, seCorner, queue);
            new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177985_f(10), queue);
            new SandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177965_g(5).func_177964_d(7), queue);
            new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177970_e(7).func_177965_g(7), queue);
        } else {
            new SandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177970_e(10).func_177965_g(4), queue);
            new SandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177965_g(15).func_177964_d(7), queue);
            new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177970_e(2).func_177965_g(17), queue);
        }
        if (neCornerAlt) {
            new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, neCorner.func_177985_f(7), queue);
            new LargeSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177970_e(10).func_177965_g(10), queue);
            new LargeSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177964_d(20).func_177965_g(13), queue);
        } else {
            new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, neCorner.func_177985_f(4), queue);
            new LargeSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177964_d(4).func_177965_g(11), queue);
            new LargeSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177964_d(15).func_177965_g(18), queue);
            new SmallSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177964_d(3).func_177985_f(13), queue);
        }
        if (swCornerAlt) {
            new SmallSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177985_f(7), queue);
            new SandstonePillarPart(this.getChallenge()).buildPart(world, swCorner.func_177970_e(10).func_177965_g(10), queue);
            new LargeSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177964_d(20).func_177985_f(6), queue);
            new LargeSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177970_e(4).func_177985_f(20), queue);
            new LargeSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177964_d(24).func_177985_f(8), queue);
        } else {
            new LargeSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177985_f(12), queue);
            new SandstonePillarPart(this.getChallenge()).buildPart(world, swCorner.func_177970_e(2).func_177965_g(6), queue);
        }
    }

    @Override
    public Set<BlockPos> buildPart(ServerWorld world, BlockPos spawnPos) {
        HashSet blocks = Sets.newHashSet();
        BlockPos nwCorner = spawnPos.func_177985_f(this.arenaSizeRadius / 2).func_177964_d(this.arenaSizeRadius / 2);
        BlockPos neCorner = spawnPos.func_177965_g(this.arenaSizeRadius / 4).func_177964_d(this.arenaSizeRadius / 4);
        BlockPos seCorner = spawnPos.func_177965_g(this.arenaSizeRadius / 2).func_177970_e(this.arenaSizeRadius / 2);
        BlockPos swCorner = spawnPos.func_177985_f(this.arenaSizeRadius / 4).func_177970_e(this.arenaSizeRadius / 2);
        boolean nwCornerAlt = this.getRNG().nextBoolean();
        boolean neCornerAlt = this.getRNG().nextBoolean();
        boolean swCornerAlt = this.getRNG().nextBoolean();
        boolean seCornerAlt = this.getRNG().nextBoolean();
        if (nwCornerAlt) {
            blocks.addAll(new SandstonePillarPart(this.getChallenge()).buildPart(world, nwCorner));
            blocks.addAll(new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, nwCorner.func_177965_g(11)));
            blocks.addAll(new SandstonePillarPart(this.getChallenge()).buildPart(world, nwCorner.func_177965_g(7).func_177964_d(7)));
        } else {
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, nwCorner.func_177964_d(5)));
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, nwCorner.func_177965_g(21)));
            blocks.addAll(new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, nwCorner.func_177965_g(2).func_177970_e(10)));
        }
        if (seCornerAlt) {
            blocks.addAll(new SandstonePillarPart(this.getChallenge()).buildPart(world, seCorner));
            blocks.addAll(new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177985_f(10)));
            blocks.addAll(new SandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177965_g(5).func_177964_d(7)));
            blocks.addAll(new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177970_e(7).func_177965_g(7)));
        } else {
            blocks.addAll(new SandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177970_e(10).func_177965_g(4)));
            blocks.addAll(new SandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177965_g(15).func_177964_d(7)));
            blocks.addAll(new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, seCorner.func_177970_e(2).func_177965_g(17)));
        }
        if (neCornerAlt) {
            blocks.addAll(new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, neCorner.func_177985_f(7)));
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177970_e(10).func_177965_g(10)));
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177964_d(20).func_177965_g(13)));
        } else {
            blocks.addAll(new BrokenSandstonePillarPart(this.getChallenge()).buildPart(world, neCorner.func_177985_f(4)));
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177964_d(4).func_177965_g(11)));
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177964_d(15).func_177965_g(18)));
            blocks.addAll(new SmallSandPilePart(this.getChallenge()).buildPart(world, neCorner.func_177964_d(3).func_177985_f(13)));
        }
        if (swCornerAlt) {
            blocks.addAll(new SmallSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177985_f(7)));
            blocks.addAll(new SandstonePillarPart(this.getChallenge()).buildPart(world, swCorner.func_177970_e(10).func_177965_g(10)));
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177964_d(20).func_177985_f(6)));
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177970_e(4).func_177985_f(20)));
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177964_d(24).func_177985_f(8)));
        } else {
            blocks.addAll(new LargeSandPilePart(this.getChallenge()).buildPart(world, swCorner.func_177985_f(12)));
            blocks.addAll(new SandstonePillarPart(this.getChallenge()).buildPart(world, swCorner.func_177970_e(2).func_177965_g(6)));
        }
        return blocks;
    }
}

