/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas.parts;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.BlockQueue;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaPart;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class BlockPilePart
extends ArenaPart {
    private BlockState state;
    private Function<BlockState, BlockState> changeFunc = state -> state;

    public BlockPilePart(InProgressChallenge challenge, BlockState state2) {
        super(challenge);
        this.state = state2;
    }

    public void setChangeFunc(Function<BlockState, BlockState> changeFUnc) {
        this.changeFunc = changeFUnc;
    }

    @Override
    public void buildPart(ServerWorld world, BlockPos spawnPos, BlockQueue queue) {
        int i = 2 + world.field_73012_v.nextInt(2);
        int j = 2 + world.field_73012_v.nextInt(2);
        ConcurrentLinkedDeque<BlockQueue.BlockQueueData> haystackDeque = new ConcurrentLinkedDeque<BlockQueue.BlockQueueData>();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)spawnPos.func_177982_a(-i, 1, -j), (BlockPos)spawnPos.func_177982_a(i, 0, j))) {
            BlockQueue.BlockQueueData queueData;
            int l;
            int k = spawnPos.func_177958_n() - blockpos.func_177958_n();
            if ((float)(k * k + (l = spawnPos.func_177952_p() - blockpos.func_177952_p()) * l) <= world.field_73012_v.nextFloat() * 10.0f - world.field_73012_v.nextFloat() * 6.0f) {
                this.state = this.changeFunc.apply(this.state);
                queueData = new BlockQueue.BlockQueueData(blockpos.func_185334_h(), this.state, 515);
                queueData.setCanPlaceCheck((world2, pos, state) -> this.mayPlaceOn(world2, pos));
                haystackDeque.add(queueData);
                continue;
            }
            if (!((double)world.field_73012_v.nextFloat() < 0.031)) continue;
            this.state = this.changeFunc.apply(this.state);
            queueData = new BlockQueue.BlockQueueData(blockpos.func_185334_h(), this.state, 515);
            queueData.setCanPlaceCheck((world2, pos, state) -> this.mayPlaceOn(world2, pos));
            haystackDeque.add(queueData);
        }
        while (!haystackDeque.isEmpty()) {
            BlockQueue.BlockQueueData queueData = (BlockQueue.BlockQueueData)haystackDeque.pollLast();
            queue.add(queueData);
        }
    }

    @Override
    public Set<BlockPos> buildPart(ServerWorld world, BlockPos spawnPos) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        int i = 2 + world.field_73012_v.nextInt(2);
        int j = 2 + world.field_73012_v.nextInt(2);
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)spawnPos.func_177982_a(-i, 0, -j), (BlockPos)spawnPos.func_177982_a(i, 1, j))) {
            int l;
            int k = spawnPos.func_177958_n() - blockpos.func_177958_n();
            if ((float)(k * k + (l = spawnPos.func_177952_p() - blockpos.func_177952_p()) * l) <= world.field_73012_v.nextFloat() * 10.0f - world.field_73012_v.nextFloat() * 6.0f) {
                if (!this.mayPlaceOn((IWorld)world, blockpos)) continue;
                this.state = this.changeFunc.apply(this.state);
                if (!AbilityHelper.placeBlockIfAllowed((World)world, blockpos, this.state, 0, null)) continue;
                blocks.add(blockpos);
                continue;
            }
            if (!((double)world.field_73012_v.nextFloat() < 0.031) || !this.mayPlaceOn((IWorld)world, blockpos)) continue;
            this.state = this.changeFunc.apply(this.state);
            if (!AbilityHelper.placeBlockIfAllowed((World)world, blockpos, this.state, 0, null)) continue;
            blocks.add(blockpos);
        }
        return blocks;
    }

    private boolean mayPlaceOn(IWorld level, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = level.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)level, blockpos, Direction.UP);
    }
}

