/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas.parts;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.BlockQueue;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaPart;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;

public class RampPart
extends ArenaPart {
    private final int width;
    private final int height;
    private final WeightedList<BlockState> slabs;
    private final WeightedList<BlockState> fills;
    private final Direction direction;

    public RampPart(InProgressChallenge challenge, int width, int height, Block slabBlock, Block fillBlock, Direction direction) {
        this(challenge, width, height, new WeightedList<BlockState>(slabBlock.func_176223_P()), new WeightedList<BlockState>(fillBlock.func_176223_P()), direction);
    }

    public RampPart(InProgressChallenge challenge, int width, int height, WeightedList<BlockState> slabs, WeightedList<BlockState> fills, Direction direction) {
        super(challenge);
        this.width = width;
        this.height = height;
        this.slabs = slabs;
        this.fills = fills;
        this.direction = direction;
    }

    @Override
    public void buildPart(ServerWorld world, BlockPos spawnPos, BlockQueue queue) {
        int xOffset = this.direction.func_176730_m().func_177958_n();
        int zOffset = this.direction.func_176730_m().func_177952_p();
        for (int i = 1; i < 1 + this.width; ++i) {
            float slabsRowY = 0.0f;
            for (int row = 1; row <= this.height; ++row) {
                for (int j = 1; j <= row; ++j) {
                    BlockState state;
                    BlockPos pos2;
                    if (j == row) {
                        if (j % 2 != 1) continue;
                        pos2 = spawnPos.func_177963_a((double)(xOffset * j), Math.floor(-slabsRowY), (double)(zOffset * j)).func_177982_a(zOffset * i, 0, xOffset * i);
                        state = this.slabs.pick(world.func_201674_k());
                        queue.add(pos2, state);
                        continue;
                    }
                    pos2 = spawnPos.func_177963_a((double)(xOffset * j), Math.floor(-slabsRowY), (double)(zOffset * j)).func_177982_a(zOffset * i, 0, xOffset * i);
                    state = this.fills.pick(world.func_201674_k());
                    queue.add(pos2, state);
                }
                slabsRowY += 0.5f;
            }
        }
    }

    @Override
    public Set<BlockPos> buildPart(ServerWorld world, BlockPos spawnPos) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        int xOffset = this.direction.func_176730_m().func_177958_n();
        int zOffset = this.direction.func_176730_m().func_177952_p();
        for (int i = 1; i < 1 + this.width; ++i) {
            float slabsRowY = 0.0f;
            for (int row = 1; row <= this.height; ++row) {
                for (int j = 1; j <= row; ++j) {
                    BlockState state;
                    BlockPos pos2;
                    if (j == row) {
                        if (j % 2 != 1 || !AbilityHelper.placeBlockIfAllowed((World)world, pos2 = spawnPos.func_177963_a((double)(xOffset * j), Math.floor(-slabsRowY), (double)(zOffset * j)).func_177982_a(zOffset * i, 0, xOffset * i), state = this.slabs.pick(world.func_201674_k()), 0, null)) continue;
                        blocks.add(pos2);
                        continue;
                    }
                    pos2 = spawnPos.func_177963_a((double)(xOffset * j), Math.floor(-slabsRowY), (double)(zOffset * j)).func_177982_a(zOffset * i, 0, xOffset * i);
                    if (!AbilityHelper.placeBlockIfAllowed((World)world, pos2, state = this.fills.pick(world.func_201674_k()), 0, null)) continue;
                    blocks.add(pos2);
                }
                slabsRowY += 0.5f;
            }
        }
        return blocks;
    }
}

