/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.poi.NTEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.POIEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.data.world.EventsWorldData;
import xyz.pixelatedw.mineminenomi.data.world.NPCWorldData;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class EventsCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"events").requires(Requires.hasPermission(3, WyPermissions.EVENTS_COMMAND));
        ((LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"list").executes(context -> EventsCommand.listEvents((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"start").then(Commands.func_197057_a((String)"notorious_target").executes(context -> EventsCommand.startNotoriousTarget((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"caravan").executes(context -> EventsCommand.startCaravan((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"celestial_dragon").executes(context -> EventsCommand.startCelestialDragon((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int listEvents(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        EventsWorldData worldData = EventsWorldData.get();
        Set<NTEventTarget> targets = worldData.getNotoriousTargets();
        Set<POIEventTarget> caravans = worldData.getCaravanPOIs();
        Set<POIEventTarget> visits = worldData.getCelestialVisitsPOIs();
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a76Targets:\u00a7r " + targets.size() + "\n");
        for (NTEventTarget nTEventTarget : targets) {
            sb.append("\n " + (int)nTEventTarget.getPosition().field_72450_a + " " + (int)nTEventTarget.getPosition().field_72448_b + " " + (int)nTEventTarget.getPosition().field_72449_c);
        }
        sb.append("\n\n");
        sb.append("\u00a76Caravans:\u00a7r " + caravans.size() + "\n");
        for (POIEventTarget pOIEventTarget : caravans) {
            sb.append("\n " + (int)pOIEventTarget.getPosition().field_72450_a + " " + (int)pOIEventTarget.getPosition().field_72448_b + " " + (int)pOIEventTarget.getPosition().field_72449_c);
        }
        sb.append("\n\n");
        sb.append("\u00a76Visits:\u00a7r " + visits.size() + "\n");
        for (POIEventTarget pOIEventTarget : visits) {
            sb.append("\n " + (int)pOIEventTarget.getPosition().field_72450_a + " " + (int)pOIEventTarget.getPosition().field_72448_b + " " + (int)pOIEventTarget.getPosition().field_72449_c);
        }
        sb.append("\n\n");
        player.func_145747_a((ITextComponent)new StringTextComponent(sb.toString()), Util.field_240973_b_);
        return 1;
    }

    private static int startNotoriousTarget(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        EventsWorldData eventsWorldData = EventsWorldData.get();
        Optional<TrackedNPC> tracked = NPCWorldData.get().getRandomTrackedMob(ModValues.PIRATE);
        if (!tracked.isPresent()) {
            return 1;
        }
        Vector3d pos = player.func_213303_ch().func_72441_c(WyHelper.randomWithRange(-10, 10), 0.0, WyHelper.randomWithRange(-10, 10));
        eventsWorldData.addNotoriousTarget(player.func_71121_q(), pos, 1200L, tracked.get());
        return 1;
    }

    private static int startCaravan(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        EventsWorldData eventsWorldData = EventsWorldData.get();
        Vector3d pos = player.func_213303_ch().func_72441_c(WyHelper.randomWithRange(-10, 10), -1.0, WyHelper.randomWithRange(-10, 10));
        eventsWorldData.addCaravan(player.func_71121_q(), pos, 1200L);
        return 1;
    }

    private static int startCelestialDragon(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        EventsWorldData eventsWorldData = EventsWorldData.get();
        Vector3d pos = player.func_213303_ch().func_72441_c(WyHelper.randomWithRange(-10, 10), 0.0, WyHelper.randomWithRange(-10, 10));
        eventsWorldData.addCelestialVisit(player.func_71121_q(), pos);
        return 1;
    }
}

