/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.abilities.FlyAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.config.GeneralConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.world.OFPWWorldData;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityProgressionEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class RemoveDFCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"removedf").requires(Requires.hasEitherPermission((Boolean)GeneralConfig.PUBLIC_REMOVEDF.get() != false ? 0 : 2, WyPermissions.REMOVE_DF_COMMAND, WyPermissions.REMOVE_DF_COMMAND_SELF));
        ((LiteralArgumentBuilder)builder.executes(context -> RemoveDFCommand.removesDF((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).requires(Requires.hasPermission(2, WyPermissions.REMOVE_DF_COMMAND))).executes(context -> RemoveDFCommand.removesDF((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int removesDF(CommandContext<CommandSource> context, ServerPlayerEntity player) throws CommandSyntaxException {
        try {
            boolean hasUnlockedFlying;
            IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
            OFPWWorldData worldData = OFPWWorldData.get();
            if (devilFruitProps.hasAnyDevilFruit()) {
                worldData.lostOneFruit(devilFruitProps.getDevilFruit().get(), (LivingEntity)player, "Removed via Command");
                if (devilFruitProps.hasYamiPower()) {
                    worldData.lostOneFruit(ModAbilities.YAMI_YAMI_NO_MI.getRegistryName(), (LivingEntity)player, "Removed via Command");
                }
                devilFruitProps.removeDevilFruit();
                devilFruitProps.clearMorphs();
                devilFruitProps.setAwakenedFruit(false);
            }
            boolean bl = hasUnlockedFlying = abilityDataProps.getPassiveAbilities(abl -> abl instanceof FlyAbility && !((FlyAbility)abl).isPaused()).size() > 0;
            if (hasUnlockedFlying && !player.func_184812_l_() && !player.func_175149_v()) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
            abilityDataProps.clearUnlockedAbilities(AbilityCategory.DEVIL_FRUITS.isCorePartofCategory());
            abilityDataProps.clearPassiveAbilities(AbilityCategory.DEVIL_FRUITS.isAbilityPartofCategory());
            abilityDataProps.clearEquippedAbilities(AbilityCategory.DEVIL_FRUITS.isAbilityPartofCategory());
            AbilityProgressionEvents.checkForRacialUnlocks((PlayerEntity)player);
            if (WyDebug.isDebug()) {
                player.func_195061_cb();
            }
            WyNetwork.sendToAllTrackingAndSelf(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), (Entity)player);
            WyNetwork.sendToAllTrackingAndSelf(new SSyncAbilityDataPacket(player.func_145782_y(), abilityDataProps), (Entity)player);
            ForgeRegistries.ATTRIBUTES.forEach(attr -> {
                if (player.func_110148_a(attr) != null) {
                    player.func_110148_a(attr).func_225505_c_().stream().filter(AbilityAttributeModifier.class::isInstance).map(AbilityAttributeModifier.class::cast).forEach(mod -> player.func_110148_a(attr).func_111124_b((AttributeModifier)mod));
                }
            });
            AbilityHelper.enableAbilities((LivingEntity)player, ability -> true);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Removed Devil Fruit for " + player.func_145748_c_().getString()), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}

