/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.ability;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCoreUnlockWrapper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponentKey;
import xyz.pixelatedw.mineminenomi.api.events.ability.EquipAbilityEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CSetCombatBarPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AbilityDataBase
implements IAbilityData {
    private LivingEntity dataOwner;
    private Set<AbilityCoreUnlockWrapper<?>> unlockedAbilities = new LinkedHashSet();
    private Set<IAbility> passiveAbilities = new LinkedHashSet<IAbility>();
    private IAbility[] activeAbilities = new IAbility[80];
    private IAbility previouslyUsedAbility;
    private int currentCombatBarSet = 0;
    private int lastCombatBarSet = 0;

    @Override
    public void initDataOwner(LivingEntity owner) {
        this.dataOwner = owner;
    }

    @Override
    public boolean addUnlockedAbility(AbilityCore core, AbilityUnlock unlockMethod) {
        if (core == null || this.hasUnlockedAbility(core)) {
            return false;
        }
        AbilityCoreUnlockWrapper unlockedCore = new AbilityCoreUnlockWrapper(this.dataOwner, core, unlockMethod);
        this.addUnlockedAbility(unlockedCore);
        if (core.getType() == AbilityType.PASSIVE) {
            this.addPassiveAbility((IAbility)core.createAbility());
        }
        return true;
    }

    @Override
    public boolean addUnlockedAbility(AbilityCoreUnlockWrapper unlockedCore) {
        AbilityCore core = unlockedCore.getAbilityCore();
        if (core == null || this.hasUnlockedAbility(core)) {
            return false;
        }
        this.unlockedAbilities.add(unlockedCore);
        if (this.dataOwner != null && this.dataOwner instanceof ServerPlayerEntity) {
            ModAdvancements.UNLOCK_ABILITY.trigger((ServerPlayerEntity)this.dataOwner, core);
        }
        return true;
    }

    @Override
    public AbilityUnlock getUnlockTypeForAbility(AbilityCore core) {
        return this.unlockedAbilities.stream().filter(pair -> pair.getAbilityCore().equals(core)).map(pair -> pair.getUnlockType()).findFirst().orElse(AbilityUnlock.NONE);
    }

    @Override
    public boolean removeUnlockedAbility(AbilityCore core) {
        if (!this.hasUnlockedAbility(core)) {
            return false;
        }
        boolean updateClient = false;
        updateClient |= this.removeEquippedAbility(core);
        if (updateClient |= this.removePassiveAbility(core)) {
            // empty if block
        }
        this.unlockedAbilities.removeIf(pair -> pair.getAbilityCore().equals(core));
        return true;
    }

    @Override
    public boolean hasUnlockedAbility(AbilityCore core) {
        return this.getUnlockedAbilities().stream().anyMatch(wrapper -> wrapper.getAbilityCore().equals(core));
    }

    @Override
    public Set<AbilityCoreUnlockWrapper> getUnlockedAbilities() {
        return this.unlockedAbilities.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Set<AbilityCoreUnlockWrapper> getUnlockedAbilities(Predicate<AbilityCore> check) {
        return this.getUnlockedAbilities().stream().filter(pair -> check.test(pair.getAbilityCore())).collect(Collectors.toSet());
    }

    public Stream<AbilityCoreUnlockWrapper<?>> getUnlockedAbilitiesStream() {
        return this.unlockedAbilities.stream().filter(Objects::nonNull);
    }

    @Override
    public Set<AbilityCore> clearUnlockedAbilities() {
        Set<AbilityCore> removed = this.unlockedAbilities.stream().map(AbilityCoreUnlockWrapper::getAbilityCore).collect(Collectors.toSet());
        removed.forEach(core -> this.removeUnlockedAbility((AbilityCore)core));
        this.unlockedAbilities.clear();
        return removed;
    }

    @Override
    public Set<AbilityCore> clearUnlockedAbilities(Predicate<AbilityCore> check) {
        Set<AbilityCoreUnlockWrapper> removed = this.unlockedAbilities.stream().filter(pair -> check.test(pair.getAbilityCore())).collect(Collectors.toSet());
        removed.forEach(pair -> this.removeUnlockedAbility(pair.getAbilityCore()));
        this.unlockedAbilities.removeAll(removed);
        return removed.stream().map(AbilityCoreUnlockWrapper::getAbilityCore).collect(Collectors.toSet());
    }

    @Override
    public int countUnlockedAbilities() {
        this.unlockedAbilities.removeIf(ability -> ability == null);
        return this.unlockedAbilities.size();
    }

    @Override
    public int countUnlockedAbilities(Predicate<AbilityCore> check) {
        return this.getUnlockedAbilities(core -> check.test((AbilityCore)core)).stream().mapToInt(a -> 1).sum();
    }

    @Override
    public boolean addPassiveAbility(IAbility abl) {
        if (this.hasPassiveAbility(abl)) {
            return false;
        }
        if (!this.hasUnlockedAbility(abl.getCore())) {
            return false;
        }
        abl.onEquip(this.dataOwner);
        this.passiveAbilities.add(abl);
        return true;
    }

    @Override
    public boolean removePassiveAbility(IAbility abl) {
        return this.removePassiveAbility(abl.getCore());
    }

    @Override
    public boolean removePassiveAbility(AbilityCore core) {
        return this.passiveAbilities.removeIf(abl -> {
            if (abl.getCore().equals(core)) {
                abl.onRemove(this.dataOwner);
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean hasPassiveAbility(IAbility abl) {
        return this.hasPassiveAbility(abl.getCore());
    }

    @Override
    public boolean hasPassiveAbility(AbilityCore core) {
        return this.getPassiveAbilities().stream().anyMatch(abl -> abl.getCore().equals(core));
    }

    @Override
    @Nullable
    public <T extends IAbility> T getPassiveAbility(AbilityCore<T> core) {
        return (T)((IAbility)this.getPassiveAbilities().stream().filter(otherAbl -> otherAbl.getCore().equals(core)).findFirst().orElse(null));
    }

    @Override
    public <T extends IAbility> Set<T> getPassiveAbilities() {
        return this.passiveAbilities.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public <T extends IAbility> Set<T> getPassiveAbilities(Predicate<IAbility> check) {
        return this.getPassiveAbilities().stream().filter(abl -> check.test((IAbility)abl) && check.test((IAbility)abl)).collect(Collectors.toSet());
    }

    @Override
    public void clearPassiveAbilities() {
        for (IAbility ability : this.passiveAbilities) {
            ability.onRemove(this.dataOwner);
        }
        this.passiveAbilities.clear();
    }

    @Override
    public void clearPassiveAbilities(Predicate<IAbility> predicate) {
        for (IAbility ability : this.passiveAbilities) {
            if (!predicate.test(ability)) continue;
            ability.onRemove(this.dataOwner);
        }
        this.passiveAbilities.removeIf(abl -> predicate.test((IAbility)abl));
    }

    @Override
    public int countPassiveAbilities() {
        return this.getPassiveAbilities().size();
    }

    @Override
    public int countPassiveAbilities(Predicate<IAbility> check) {
        return this.getPassiveAbilities().stream().filter(abl -> check.test((IAbility)abl)).mapToInt(a -> 1).sum();
    }

    @Override
    public boolean setEquippedAbility(int slot, @Nullable IAbility abl) {
        if (slot < 0) {
            return false;
        }
        if (abl != null) {
            if (this.hasEquippedAbility(abl)) {
                return false;
            }
            EquipAbilityEvent event = new EquipAbilityEvent(this.dataOwner, abl);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            abl.onEquip(this.dataOwner);
        } else if (this.activeAbilities[slot] != null) {
            this.activeAbilities[slot].onRemove(this.dataOwner);
        }
        this.activeAbilities[slot] = abl;
        return true;
    }

    @Override
    public boolean removeEquippedAbility(IAbility abl) {
        if (abl == null) {
            return false;
        }
        return this.removeEquippedAbility(abl.getCore());
    }

    @Override
    public boolean removeEquippedAbility(AbilityCore core) {
        for (int i = 0; i < this.activeAbilities.length; ++i) {
            IAbility ability = this.activeAbilities[i];
            if (ability == null || !ability.getCore().equals(core)) continue;
            ability.onRemove(this.dataOwner);
            this.activeAbilities[i] = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEquippedAbility(IAbility abl) {
        if (abl == null) {
            return false;
        }
        return this.hasEquippedAbility(abl.getCore());
    }

    @Override
    public boolean hasEquippedAbility(AbilityCore core) {
        return Arrays.stream(this.activeAbilities).filter(ability -> ability != null).anyMatch(ability -> ability.getCore().equals(core));
    }

    @Override
    public int getEquippedAbilitySlot(IAbility abl) {
        if (abl == null) {
            return -1;
        }
        return this.getEquippedAbilitySlot(abl.getCore());
    }

    @Override
    public int getEquippedAbilitySlot(AbilityCore core) {
        if (core == null) {
            return -1;
        }
        for (int i = 0; i < this.activeAbilities.length; ++i) {
            IAbility ability = this.activeAbilities[i];
            if (ability == null || !ability.getCore().equals(core)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @Nullable
    public <T extends IAbility> T getEquippedAbility(T abl) {
        return (T)((IAbility)Arrays.stream(this.activeAbilities).filter(ability -> ability != null && ability.equals(abl)).findFirst().orElse(null));
    }

    @Override
    @Nullable
    public <T extends IAbility> T getEquippedAbility(AbilityCore<T> core) {
        return (T)((IAbility)Arrays.stream(this.activeAbilities).filter(ability -> ability != null && ability.getCore().equals(core)).findFirst().orElse(null));
    }

    @Override
    @Nullable
    public <T extends IAbility> T getEquippedAbility(int slot) {
        if (slot < 0) {
            return null;
        }
        if (this.activeAbilities.length < slot) {
            return null;
        }
        return (T)this.activeAbilities[slot];
    }

    public List<IAbility> getRawEquippedAbilities() {
        LinkedList list = Lists.newLinkedList();
        Collections.addAll(list, this.activeAbilities);
        return list;
    }

    @Override
    public <T extends IAbility> Set<T> getEquippedAbilities() {
        return Arrays.stream(this.activeAbilities).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public <T extends IAbility> Set<T> getEquippedAbilities(Predicate<IAbility> check) {
        return Arrays.stream(this.activeAbilities).filter(abl -> abl != null && check.test((IAbility)abl)).collect(Collectors.toSet());
    }

    @Override
    public <T extends IAbility> Set<T> getEquippedAbilitiesWith(AbilityComponentKey ... keys) {
        return Arrays.stream(this.activeAbilities).filter(abl -> abl != null && Arrays.stream(keys).allMatch(key -> abl.hasComponent((AbilityComponentKey)key))).collect(Collectors.toSet());
    }

    @Override
    public void clearEquippedAbilities() {
        for (int i = 0; i < this.activeAbilities.length; ++i) {
            IAbility ability = this.activeAbilities[i];
            if (ability != null) {
                ability.onRemove(this.dataOwner);
            }
            this.activeAbilities[i] = null;
        }
    }

    @Override
    public void clearEquippedAbilities(Predicate<IAbility> predicate) {
        for (int i = 0; i < this.activeAbilities.length; ++i) {
            IAbility ability = this.activeAbilities[i];
            if (ability == null || !predicate.test(ability)) continue;
            ability.onRemove(this.dataOwner);
            this.activeAbilities[i] = null;
        }
    }

    @Override
    public int countEquippedAbilities() {
        return Arrays.stream(this.activeAbilities).filter(ability -> ability != null).mapToInt(a -> 1).sum();
    }

    @Override
    public int countEquippedAbilities(Predicate<IAbility> check) {
        return Arrays.stream(this.activeAbilities).filter(ability -> ability != null && check.test((IAbility)ability)).mapToInt(a -> 1).sum();
    }

    @Override
    @Nullable
    public <T extends IAbility> T getEquippedOrPassiveAbility(AbilityCore<T> core) {
        return (T)((IAbility)this.getEquippedAndPassiveAbilities().stream().filter(abl -> abl.getCore().equals(core)).findFirst().orElse(null));
    }

    @Override
    public Set<IAbility> getEquippedAndPassiveAbilities() {
        HashSet<IAbility> set = new HashSet<IAbility>();
        set.addAll(this.getPassiveAbilities());
        set.addAll(this.getEquippedAbilities());
        return set;
    }

    @Override
    public Set<IAbility> getEquippedAndPassiveAbilities(Predicate<IAbility> check) {
        HashSet<IAbility> set = new HashSet<IAbility>();
        set.addAll(this.getPassiveAbilities(check));
        set.addAll(this.getEquippedAbilities(check));
        return set;
    }

    @Override
    public <T extends IAbility> T getPreviouslyUsedAbility() {
        return (T)this.previouslyUsedAbility;
    }

    @Override
    public void setPreviouslyUsedAbility(IAbility abl) {
        this.previouslyUsedAbility = abl;
    }

    @Override
    public int getCombatBarSet() {
        return Math.max(0, this.currentCombatBarSet);
    }

    @Override
    public void nextCombatBarSet(int amount) {
        this.lastCombatBarSet = this.currentCombatBarSet;
        this.currentCombatBarSet = MathHelper.func_76125_a((int)(this.currentCombatBarSet + amount), (int)0, (int)(CommonConfig.INSTANCE.getAbilityBars() - 1));
        if (this.dataOwner != null && this.dataOwner.field_70170_p.field_72995_K) {
            WyNetwork.sendToServer(new CSetCombatBarPacket(this.getCombatBarSet()));
        }
    }

    @Override
    public void prevCombatBarSet(int amount) {
        this.lastCombatBarSet = this.currentCombatBarSet;
        this.currentCombatBarSet = MathHelper.func_76125_a((int)(this.currentCombatBarSet - amount), (int)0, (int)(CommonConfig.INSTANCE.getAbilityBars() - 1));
        if (this.dataOwner != null && this.dataOwner.field_70170_p.field_72995_K) {
            WyNetwork.sendToServer(new CSetCombatBarPacket(this.getCombatBarSet()));
        }
    }

    @Override
    public int getLastCombatBarSet() {
        return this.lastCombatBarSet;
    }

    @Override
    public void setCombatBarSet(int set) {
        this.lastCombatBarSet = this.currentCombatBarSet;
        this.currentCombatBarSet = set;
        if (this.dataOwner != null && this.dataOwner.field_70170_p.field_72995_K) {
            WyNetwork.sendToServer(new CSetCombatBarPacket(this.getCombatBarSet()));
        }
    }
}

