/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.challenges;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeInvitation;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;

public class ChallengesDataBase
implements IChallengesData {
    private PlayerEntity owner;
    private boolean isArenaDirty;
    private ChallengeCore<?> previousChallenge;
    private ArenaStyle previousArenaStyle;
    private String previousArenaClass;
    private UUID groupOwner;
    private List<UUID> group = new ArrayList<UUID>();
    private List<Challenge> challenges = new ArrayList<Challenge>();
    private List<ChallengeInvitation> invitations = new ArrayList<ChallengeInvitation>();

    @Override
    public IChallengesData setOwner(PlayerEntity entity) {
        this.owner = entity;
        return this;
    }

    @Override
    public boolean isInGroup() {
        return this.groupOwner != null;
    }

    @Override
    public void setInGroup(@Nullable UUID groupOwnerId) {
        this.groupOwner = groupOwnerId;
    }

    @Override
    public ImmutableList<UUID> getGroupMembersIds() {
        return ImmutableList.copyOf(this.group);
    }

    @Override
    public boolean isGroupMember(UUID id) {
        return this.group.contains(id);
    }

    @Override
    public void removeGroupMember(UUID playerId) {
        this.group.remove(playerId);
    }

    @Override
    public void addGroupMember(PlayerEntity player) {
        if (player == null) {
            return;
        }
        ChallengesDataCapability.get(player).setInGroup(this.owner.func_110124_au());
        this.group.add(player.func_110124_au());
    }

    @Override
    public ImmutableList<ChallengeInvitation> getInvitations() {
        return ImmutableList.copyOf(this.invitations);
    }

    @Override
    public Optional<ChallengeInvitation> getInvitationFrom(UUID senderId) {
        for (ChallengeInvitation invite : this.invitations) {
            if (!invite.getSenderId().equals(senderId)) continue;
            return Optional.ofNullable(invite);
        }
        return Optional.empty();
    }

    @Override
    public boolean hasInvitationFrom(UUID senderId) {
        for (ChallengeInvitation invite : this.invitations) {
            if (!invite.getSenderId().equals(senderId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInvitationFrom(PlayerEntity sender) {
        return this.hasInvitationFrom(sender.func_110124_au());
    }

    @Override
    public void addInvitation(ChallengeInvitation challenge) {
        if (this.hasInvitationFrom(challenge.getSenderId())) {
            return;
        }
        this.invitations.add(challenge);
    }

    @Override
    public void removeInvitationFrom(PlayerEntity player) {
        Iterator<ChallengeInvitation> iter = this.invitations.iterator();
        while (iter.hasNext()) {
            ChallengeInvitation invite = iter.next();
            if (!invite.getSenderId().equals(player.func_110124_au())) continue;
            iter.remove();
            return;
        }
    }

    @Override
    public void tickInvitations() {
        if (this.invitations.isEmpty()) {
            return;
        }
        World world = this.owner.func_130014_f_();
        long currentTime = world.func_82737_E();
        ChallengesWorldData worldData = ChallengesWorldData.get();
        Iterator<ChallengeInvitation> iter = this.invitations.iterator();
        while (iter.hasNext()) {
            ChallengeInvitation invite = iter.next();
            PlayerEntity sender = invite.getSender(world);
            if (!world.func_217369_A().contains(sender)) {
                ModMain.LOGGER.debug("Removed invitation due to missing sender");
                iter.remove();
                continue;
            }
            if (invite.isExpired(world)) {
                ModMain.LOGGER.debug("Removed invitation due to timeout");
                iter.remove();
                continue;
            }
            if (worldData.getInProgressChallengeFor((LivingEntity)sender) == null) continue;
            ModMain.LOGGER.debug("Removed invitation due to it already starting");
            iter.remove();
        }
    }

    @Override
    public ChallengeCore<?> getPreviousChallenge() {
        return this.previousChallenge;
    }

    @Override
    public ArenaStyle getPreviousArenaStyle() {
        return this.previousArenaStyle;
    }

    @Override
    public String getPreviousArenaClass() {
        return this.previousArenaClass;
    }

    @Override
    public void setPreviousChallenge(ChallengeCore<?> challenge, ArenaStyle style, String clz) {
        this.previousChallenge = challenge;
        this.previousArenaStyle = style;
        this.previousArenaClass = clz;
    }

    @Override
    public boolean isArenaDirty() {
        return this.isArenaDirty;
    }

    @Override
    public void markArenaDirty(boolean flag) {
        this.isArenaDirty = flag;
    }

    @Override
    public boolean addChallenge(Challenge challenge) {
        if (this.hasChallenge(challenge.getCore())) {
            return false;
        }
        this.challenges.add(challenge);
        if (this.owner instanceof ServerPlayerEntity) {
            ModAdvancements.UNLOCK_CHALLENGE.trigger((ServerPlayerEntity)this.owner, challenge.getCore());
        }
        return true;
    }

    @Override
    public boolean addChallenge(ChallengeCore<?> core) {
        if (this.hasChallenge(core)) {
            return false;
        }
        Object challenge = core.createChallenge();
        return this.addChallenge((Challenge)challenge);
    }

    @Override
    public boolean removeChallenge(ChallengeCore<?> core) {
        if (!this.hasChallenge(core)) {
            return false;
        }
        this.challenges.removeIf(ch -> ((Object)((Object)ch.getCore())).equals(core));
        return true;
    }

    @Override
    public boolean hasChallenge(ChallengeCore<?> core) {
        return this.getChallenge(core) != null;
    }

    @Override
    public boolean isChallengeCompleted(ChallengeCore<?> core) {
        Object ch = this.getChallenge(core);
        if (ch == null) {
            return false;
        }
        return ((Challenge)ch).isComplete();
    }

    @Override
    @Nullable
    public <T extends Challenge> T getChallenge(ChallengeCore<?> core) {
        return (T)((Challenge)this.challenges.stream().filter(ch -> ((Object)((Object)ch.getCore())).equals(core)).findFirst().orElse(null));
    }

    @Override
    public List<Challenge> getChallenges() {
        return this.challenges.stream().filter(ch -> ch != null).collect(Collectors.toList());
    }

    @Override
    public int countChallenges() {
        this.challenges.removeIf(chl -> chl == null);
        return this.challenges.size();
    }

    @Override
    public void clearChallenges() {
        this.challenges.clear();
    }
}

