/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.devilfruit;

import joptsimple.internal.Strings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitBase;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public class DevilFruitCapability {
    public static final Logger LOGGER = LogManager.getLogger((String)"mineminenomi.DEVIL_FRUIT_CAPABILITY");
    @CapabilityInject(value=IDevilFruit.class)
    public static final Capability<IDevilFruit> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IDevilFruit.class, (Capability.IStorage)new Capability.IStorage<IDevilFruit>(){

            public INBT writeNBT(Capability<IDevilFruit> capability, IDevilFruit instance, Direction side) {
                CompoundNBT props = new CompoundNBT();
                props.func_74768_a("version", instance.getVersion());
                String devilFruit = instance.getDevilFruit().map(ResourceLocation::toString).orElse("");
                props.func_74778_a("devilFruit", devilFruit);
                props.func_74757_a("hasAwakenedFruit", instance.hasAwakenedFruit());
                props.func_74757_a("hasYamiPower", instance.hasYamiPower());
                props.func_74778_a("zoanPoint", instance.getZoanPoint());
                instance.getCurrentMorph().ifPresent(morph -> props.func_74778_a("morph", morph.getRegistryName().toString()));
                return props;
            }

            public void readNBT(Capability<IDevilFruit> capability, IDevilFruit instance, Direction side, INBT nbt) {
                CompoundNBT props = (CompoundNBT)nbt;
                if (!props.func_74764_b("version") || props.func_74762_e("version") < 2) {
                    DevilFruitCapability.portToV2(instance, props);
                }
                String devilFruitProp = props.func_74779_i("devilFruit");
                ResourceLocation devilFruit = null;
                if (props.func_74764_b("devilFruit") && !Strings.isNullOrEmpty((String)devilFruitProp)) {
                    devilFruit = new ResourceLocation(devilFruitProp);
                }
                instance.setDevilFruit(devilFruit);
                if (CommonConfig.INSTANCE.hasAwakeningsEnabled()) {
                    instance.setAwakenedFruit(props.func_74767_n("hasAwakenedFruit"));
                } else {
                    instance.setAwakenedFruit(false);
                }
                instance.setYamiPower(props.func_74767_n("hasYamiPower"));
                instance.setZoanPoint(props.func_74779_i("zoanPoint"));
                if (props.func_74764_b("morph")) {
                    ResourceLocation morphId = new ResourceLocation(props.func_74779_i("morph"));
                    MorphInfo morph = (MorphInfo)ModRegistries.MORPHS.getValue(morphId);
                    instance.addMorph(morph);
                }
            }
        }, () -> new DevilFruitBase());
    }

    private static void portToV2(IDevilFruit instance, CompoundNBT props) {
        String oldId = props.func_74779_i("devilFruit");
        AkumaNoMiItem df = null;
        if (oldId.equals("yamidummy")) {
            df = ModAbilities.YAMI_YAMI_NO_MI;
        }
        if (df == null) {
            df = DevilFruitHelper.getLegacyDevilFruitItem(oldId);
        }
        if (df != null && df != Items.field_190931_a) {
            props.func_74778_a("devilFruit", df.getRegistryName().toString());
            LOGGER.info("Succesfully ported the legacy fruit {} into {}", (Object)oldId, instance.getDevilFruit());
        }
    }

    public static IDevilFruit get(LivingEntity entity) {
        IDevilFruit props = (IDevilFruit)entity.getCapability(INSTANCE, null).orElse((Object)new DevilFruitBase());
        props.setOwner(entity);
        return props;
    }
}

