/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.entitystats;

import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsBase;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class EntityStatsCapability {
    @CapabilityInject(value=IEntityStats.class)
    public static final Capability<IEntityStats> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IEntityStats.class, (Capability.IStorage)new Capability.IStorage<IEntityStats>(){

            public INBT writeNBT(Capability<IEntityStats> capability, IEntityStats instance, Direction side) {
                CompoundNBT props = new CompoundNBT();
                props.func_74780_a("doriki", instance.getDoriki());
                props.func_74768_a("cola", instance.getCola());
                props.func_74768_a("ultraCola", instance.getUltraCola());
                props.func_74780_a("loyalty", instance.getLoyalty());
                props.func_74768_a("invulnerableTime", instance.getInvulnerableTime());
                props.func_74780_a("damageMultiplier", instance.getDamageMultiplier());
                props.func_74772_a("bounty", instance.getBounty());
                props.func_74772_a("belly", instance.getBelly());
                props.func_74772_a("extol", instance.getExtol());
                props.func_74778_a("faction", instance.getFaction().toString());
                props.func_74778_a("race", instance.getRace().toString());
                props.func_74778_a("subRace", instance.getSubRace());
                props.func_74778_a("fightingStyle", instance.getFightingStyle().toString());
                props.func_74757_a("hasShadow", instance.hasShadow());
                props.func_74757_a("hadChiyuEffect", instance.hadChiyuEffect());
                props.func_74757_a("hasHeart", instance.hasHeart());
                props.func_74757_a("hasStrawDoll", instance.hasStrawDoll());
                props.func_74757_a("isInCombatMode", instance.isInCombatMode());
                props.func_74757_a("isRogue", instance.isRogue());
                props.func_74776_a("originalChiyupopoHealth", instance.getOriginalChiyupopoHealth());
                props.func_74768_a("freedSlaves", instance.getFreedSlaves());
                return props;
            }

            public void readNBT(Capability<IEntityStats> capability, IEntityStats instance, Direction side, INBT nbt) {
                CompoundNBT props = (CompoundNBT)nbt;
                instance.setDoriki(props.func_74769_h("doriki"));
                instance.setUltraCola(props.func_74762_e("ultraCola"));
                instance.setForcedCola(props.func_74762_e("cola"));
                instance.setLoyalty(props.func_74769_h("loyalty"));
                instance.setInvulnerableTime(props.func_74762_e("invulnerableTime"));
                instance.setDamageMultiplier(props.func_74769_h("damageMultiplier"));
                instance.setBelly(props.func_74763_f("belly"));
                instance.setBounty(props.func_74763_f("bounty"));
                instance.setExtol(props.func_74763_f("extol"));
                instance.setFaction(WyHelper.getResourceLocation(props, "faction"));
                instance.setRace(WyHelper.getResourceLocation(props, "race"));
                instance.setSubRace(props.func_74779_i("subRace"));
                instance.setFightingStyle(WyHelper.getResourceLocation(props, "fightingStyle"));
                instance.setShadow(props.func_74767_n("hasShadow"));
                instance.setChiyuEffect(props.func_74767_n("hadChiyuEffect"));
                instance.setHeart(props.func_74767_n("hasHeart"));
                instance.setStrawDoll(props.func_74767_n("hasStrawDoll"));
                instance.setCombatMode(props.func_74767_n("isInCombatMode"));
                instance.setRogue(props.func_74767_n("isRogue"));
                instance.setOriginalChiyupopoHealth(props.func_74760_g("originalChiyupopoHealth"));
                instance.setFreedSlaves(props.func_74762_e("freedSlaves"));
            }
        }, () -> new EntityStatsBase());
    }

    public static IEntityStats get(LivingEntity entity) {
        IEntityStats props = (IEntityStats)entity.getCapability(INSTANCE, null).orElse((Object)new EntityStatsBase());
        props.setOwner(entity);
        return props;
    }
}

