/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.gcd;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.gcd.IGCD;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class GCDBase
implements IGCD {
    private static final int DEFAULT_GCD = 20;
    private LivingEntity owner;
    private int previousGCD = 20;
    private Interval gcdInterval = (Interval)new Interval(20).trackTPS();
    private boolean onGCD = false;

    @Override
    public IGCD setOwner(LivingEntity owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public void startGCD() {
        if (this.isOnGCD()) {
            return;
        }
        int defaultGCD = this.getDefaultGCD();
        if (this.previousGCD != defaultGCD) {
            this.previousGCD = defaultGCD;
            this.gcdInterval = (Interval)new Interval(defaultGCD).trackTPS();
        }
        this.gcdInterval.restartIntervalToMax();
        this.onGCD = true;
    }

    @Override
    public boolean isOnGCD() {
        return this.onGCD;
    }

    @Override
    public void tickGCD() {
        if (this.onGCD && this.gcdInterval.canTick()) {
            this.onGCD = false;
        }
    }

    @Override
    public int getCurrentGCD() {
        return this.gcdInterval.getTick();
    }

    @Override
    public int getDefaultGCD() {
        try {
            ModifiableAttributeInstance attr = this.owner.func_110148_a((Attribute)ModAttributes.GCD.get());
            if (attr == null) {
                return 20;
            }
            return (int)Math.round(attr.func_111126_e());
        }
        catch (Exception ex) {
            return 20;
        }
    }
}

