/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.quests;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.registry.GameRegistry;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataBase;

public class QuestDataCapability {
    @CapabilityInject(value=IQuestData.class)
    public static final Capability<IQuestData> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IQuestData.class, (Capability.IStorage)new Capability.IStorage<IQuestData>(){

            public INBT writeNBT(Capability<IQuestData> capability, IQuestData instance, Direction side) {
                CompoundNBT props = new CompoundNBT();
                ListNBT questsInTracker = new ListNBT();
                for (int i = 0; i < instance.getInProgressQuests().length; ++i) {
                    Quest quest = instance.getInProgressQuests()[i];
                    if (quest == null) continue;
                    questsInTracker.add((Object)quest.save());
                }
                props.func_218657_a("quests_in_tracker", (INBT)questsInTracker);
                ListNBT finishedQuests = new ListNBT();
                for (int i = 0; i < instance.getFinishedQuests().size(); ++i) {
                    QuestId quest = instance.getFinishedQuests().get(i);
                    CompoundNBT questNbt = new CompoundNBT();
                    questNbt.func_74778_a("id", quest.getRegistryName().toString());
                    finishedQuests.add((Object)questNbt);
                }
                props.func_218657_a("finished_quests", (INBT)finishedQuests);
                return props;
            }

            public void readNBT(Capability<IQuestData> capability, IQuestData instance, Direction side, INBT nbt) {
                Object quest;
                CompoundNBT props = (CompoundNBT)nbt;
                instance.clearInProgressQuests();
                instance.clearFinishedQuests();
                ListNBT trackerQuests = props.func_150295_c("quests_in_tracker", 10);
                for (int i = 0; i < trackerQuests.size(); ++i) {
                    try {
                        CompoundNBT nbtQuests = trackerQuests.func_150305_b(i);
                        QuestId questId = (QuestId)GameRegistry.findRegistry(QuestId.class).getValue(new ResourceLocation(nbtQuests.func_74779_i("id")));
                        if (questId == null) continue;
                        quest = questId.createQuest();
                        ((Quest)quest).load(nbtQuests);
                        instance.setInProgressQuest(i, (Quest)quest);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ListNBT finishedQuests = props.func_150295_c("finished_quests", 10);
                for (int i = 0; i < finishedQuests.size(); ++i) {
                    try {
                        CompoundNBT nbtQuests = finishedQuests.func_150305_b(i);
                        quest = (QuestId)GameRegistry.findRegistry(QuestId.class).getValue(new ResourceLocation(nbtQuests.func_74779_i("id")));
                        instance.addFinishedQuest((QuestId)((Object)quest));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }, QuestDataBase::new);
    }

    public static IQuestData get(PlayerEntity entity) {
        IQuestData props = (IQuestData)entity.getCapability(INSTANCE, null).orElse((Object)new QuestDataBase());
        props.setOwner(entity);
        return props;
    }
}

