/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.functions;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.functions.IncreaseStatFunction;
import xyz.pixelatedw.mineminenomi.init.ModLootTypes;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class IncreaseBellyFunction
extends IncreaseStatFunction {
    protected IncreaseBellyFunction(ILootCondition[] conditions, IRandomRange amount, StatChangeSource source) {
        super(conditions, amount, source);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity != null && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Entity killer = (Entity)context.func_216031_c(LootParameters.field_216284_d);
            int amount = this.amount.func_186511_a(context.func_216032_b());
            if (killer != null && killer instanceof LivingEntity) {
                target = (LivingEntity)killer;
                if (this.source == StatChangeSource.KILL_NPC) {
                    amount = CommonConfig.INSTANCE.isMobRewardsEnabled() ? (int)((double)amount * CommonConfig.INSTANCE.getBellyRewardMultiplier()) : 0;
                }
            }
            if (this.source == StatChangeSource.CHALLENGE && entity instanceof PlayerEntity && this.scaleDownChallengeCompletion) {
                ChallengeCore core = (ChallengeCore)((Object)context.func_216031_c(ModLootTypes.COMPLETED_CHALLENGE));
                IChallengesData challengeData = ChallengesDataCapability.get((PlayerEntity)entity);
                Object challenge = challengeData.getChallenge(core);
                amount = this.scaleValueFromCompletions((Challenge)challenge, amount);
            }
            IEntityStats props = EntityStatsCapability.get(target);
            boolean hasUpdate = props.alterBelly(amount, this.source);
            if (target instanceof ServerPlayerEntity && hasUpdate) {
                WyNetwork.sendTo(new SSyncEntityStatsPacket(target.func_145782_y(), props), (PlayerEntity)((ServerPlayerEntity)target));
            }
            stack.func_200302_a((ITextComponent)new StringTextComponent("_rewards"));
            stack.func_196082_o().func_74768_a("_rewardsBelly", amount);
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return ModLootTypes.INCREASE_BELLY;
    }

    public static LootFunction.Builder<?> builder(int amount, StatChangeSource source) {
        return IncreaseBellyFunction.builder((IRandomRange)ConstantRange.func_215835_a((int)amount), source);
    }

    public static LootFunction.Builder<?> builder(IRandomRange amount, StatChangeSource source) {
        return IncreaseBellyFunction.builder(amount, source, false);
    }

    public static LootFunction.Builder<?> builder(IRandomRange amount, StatChangeSource source, boolean scaleDown) {
        return IncreaseBellyFunction.func_215860_a(condition -> {
            IncreaseBellyFunction func = new IncreaseBellyFunction((ILootCondition[])condition, amount, source);
            func.scaleDownChallengeCompletion = scaleDown;
            return func;
        });
    }

    public static IncreaseBellyFunction create(ILootCondition[] conditions, IRandomRange amount, StatChangeSource source) {
        return new IncreaseBellyFunction(conditions, amount, source);
    }
}

