/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.RandomRanges;
import net.minecraft.loot.conditions.ILootCondition;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class IncreaseStatFunction
extends LootFunction {
    protected IRandomRange amount;
    protected StatChangeSource source;
    protected boolean scaleDownChallengeCompletion = false;

    public IncreaseStatFunction(ILootCondition[] conditions, IRandomRange amount, StatChangeSource source) {
        super(conditions);
        this.amount = amount;
        this.source = source;
    }

    public IRandomRange getAmount() {
        return this.amount;
    }

    public StatChangeSource getSource() {
        return this.source;
    }

    public boolean scalesDownChallengeCompletion() {
        return this.scaleDownChallengeCompletion;
    }

    public int scaleValueFromCompletions(Challenge challenge, int amount) {
        int completions = challenge.getCompletions();
        if ((completions = Math.min(completions, 10)) > 0) {
            float d = (float)completions * 1.5f;
            amount = (int)((float)amount / d);
        }
        if ((amount = Math.max(amount, 1)) % 10 != 0 && amount > 10) {
            amount = WyHelper.roundToNiceNumber(amount);
        }
        return amount;
    }

    @FunctionalInterface
    public static interface IFunctionFactory<F extends IncreaseStatFunction> {
        public F create(ILootCondition[] var1, IRandomRange var2, StatChangeSource var3);
    }

    public static class Serializer<F extends IncreaseStatFunction>
    extends LootFunction.Serializer<F> {
        private IFunctionFactory<F> factory;

        public Serializer(IFunctionFactory<F> factory) {
            this.factory = factory;
        }

        public void serialize(JsonObject object, F func, JsonSerializationContext context) {
            super.func_230424_a_(object, func, context);
            object.add("amount", context.serialize((Object)((IncreaseStatFunction)((Object)func)).getAmount()));
            object.add("source", context.serialize((Object)((IncreaseStatFunction)((Object)func)).getSource()));
            object.add("scaleDownChallengeCompletion", context.serialize((Object)((IncreaseStatFunction)((Object)func)).scalesDownChallengeCompletion()));
        }

        public F deserialize(JsonObject object, JsonDeserializationContext context, ILootCondition[] cond) {
            IRandomRange amount = RandomRanges.func_216130_a((JsonElement)object.get("amount"), (JsonDeserializationContext)context);
            StatChangeSource source = (StatChangeSource)((Object)context.deserialize(object.get("source"), StatChangeSource.class));
            F func = this.factory.create(cond, amount, source);
            ((IncreaseStatFunction)((Object)func)).scaleDownChallengeCompletion = object.has("scaleDownChallengeCompletion") ? (Boolean)context.deserialize(object.get("scaleDownChallengeCompletion"), Boolean.class) : false;
            return func;
        }
    }
}

