/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.world;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCache;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.world.ChallengesChunkGenerator;
import xyz.pixelatedw.mineminenomi.world.DynamicDimensionManager;

public class ChallengesWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi-challenges";
    private static final TranslationTextComponent NOT_UNLOCKED = new TranslationTextComponent(ModI18n.CHALLENGE_MESSAGE_NOT_UNLOCKED);
    private static final ChallengesWorldData INSTANCE = ChallengesWorldData.initWorldData();
    private Map<UUID, InProgressChallenge> inProgressChallenges = new HashMap<UUID, InProgressChallenge>();
    private Map<Integer, InProgressChallenge> inProgressChallengesHashCache = new HashMap<Integer, InProgressChallenge>();
    private Map<UUID, ChallengeCache> challengerCache = new HashMap<UUID, ChallengeCache>();

    private static ChallengesWorldData initWorldData() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (ChallengesWorldData)ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x().func_215752_a(ChallengesWorldData::new, IDENTIFIER);
        }
        return null;
    }

    public ChallengesWorldData() {
        super(IDENTIFIER);
    }

    @Nullable
    public static ChallengesWorldData get() {
        return INSTANCE;
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT cache = new ListNBT();
        for (Map.Entry<UUID, ChallengeCache> entry : this.challengerCache.entrySet()) {
            CompoundNBT entryNbt = new CompoundNBT();
            entryNbt.func_186854_a("id", entry.getKey());
            entryNbt.func_218657_a("data", (INBT)entry.getValue().save());
            cache.add((Object)entryNbt);
        }
        nbt.func_218657_a("cache", (INBT)cache);
        return nbt;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.challengerCache.clear();
        ListNBT cache = nbt.func_150295_c("cache", 10);
        for (int i = 0; i < cache.size(); ++i) {
            CompoundNBT entryNbt = cache.func_150305_b(i);
            UUID id = entryNbt.func_186857_a("id");
            ChallengeCache data = ChallengeCache.from(entryNbt.func_74775_l("data"));
            this.challengerCache.put(id, data);
        }
    }

    public boolean startChallenge(ServerPlayerEntity player, List<LivingEntity> group, ChallengeCore<?> core, boolean isFree) {
        if (!CommonConfig.INSTANCE.isChallengesEnabled()) {
            return false;
        }
        IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
        if (props != null) {
            Object challenge = props.getChallenge(core);
            if (challenge == null) {
                player.func_145747_a((ITextComponent)NOT_UNLOCKED, Util.field_240973_b_);
                return false;
            }
            ModMain.LOGGER.info(player.func_146103_bH().getName() + " started " + ((Challenge)challenge).getCore().getId().toUpperCase() + " challenge.");
            long start = System.nanoTime();
            ResourceLocation dimName = new ResourceLocation("mineminenomi", "challenges_" + player.func_189512_bd());
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimName);
            DynamicRegistries registryAccess = player.field_70170_p.func_241828_r();
            Supplier<DimensionType> type = () -> (DimensionType)registryAccess.func_243612_b(Registry.field_239698_ad_).func_243576_d(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)ModResources.DIMENSION_TYPE_CHALLENGES));
            ServerWorld shard = DynamicDimensionManager.getOrCreateWorld(player.func_184102_h(), (RegistryKey<World>)dimension, (minecraftServer, levelStemResourceKey) -> {
                ChallengesChunkGenerator generator = new ChallengesChunkGenerator((Registry<Biome>)registryAccess.func_243612_b(Registry.field_239720_u_));
                return new Dimension(type, (ChunkGenerator)generator);
            });
            UUID id = player.func_110124_au();
            InProgressChallenge inProgressChallenge = new InProgressChallenge(id, player, shard, group, (Challenge)challenge, isFree);
            if (this.inProgressChallenges.containsKey(id)) {
                this.stopChallenge(inProgressChallenge);
            }
            this.inProgressChallenges.put(id, inProgressChallenge);
            for (Map.Entry<UUID, ChallengeCache> entry : inProgressChallenge.getGroupCache().entrySet()) {
                this.challengerCache.put(entry.getKey(), entry.getValue());
            }
            this.func_76185_a();
            long end = System.nanoTime();
            long elapsed = (end - start) / 1000000L;
            ModMain.LOGGER.debug("Dimension setup: " + elapsed + "ms");
            return true;
        }
        return false;
    }

    public void stopChallenge(InProgressChallenge inProgChallenge) {
        IChallengesData challengeProps = ChallengesDataCapability.get((PlayerEntity)inProgChallenge.getOwner());
        for (UUID uuid : challengeProps.getGroupMembersIds()) {
            ServerPlayerEntity groupMember = inProgChallenge.getShard().func_73046_m().func_184103_al().func_177451_a(uuid);
            if (groupMember == null) continue;
            ChallengesDataCapability.get((PlayerEntity)groupMember).setInGroup(null);
            challengeProps.removeGroupMember(groupMember.func_110124_au());
        }
        challengeProps.setInGroup(null);
        challengeProps.removeGroupMember(inProgChallenge.getOwner().func_110124_au());
        ModMain.LOGGER.info(inProgChallenge.getOwner().func_146103_bH().getName() + "'s challenge stopped.");
        for (UUID key : inProgChallenge.getGroupCache().keySet()) {
            this.challengerCache.remove(key);
        }
        this.inProgressChallenges.remove(inProgChallenge.getId());
        this.inProgressChallengesHashCache.remove(inProgChallenge.getShard().hashCode());
        this.func_76185_a();
    }

    @Nullable
    public InProgressChallenge getInProgressChallengeFor(LivingEntity entity) {
        UUID id = entity.func_110124_au();
        return this.inProgressChallenges.get(id);
    }

    @Nullable
    public InProgressChallenge getInProgressChallengeFor(ServerWorld world) {
        if (this.inProgressChallengesHashCache.isEmpty() && this.inProgressChallenges.isEmpty()) {
            return null;
        }
        if (this.inProgressChallengesHashCache.containsKey(world.hashCode())) {
            return this.inProgressChallengesHashCache.get(world.hashCode());
        }
        for (InProgressChallenge challenge : this.inProgressChallenges.values()) {
            if (!challenge.getShard().equals(world)) continue;
            this.inProgressChallengesHashCache.put(world.hashCode(), challenge);
            return challenge;
        }
        return null;
    }

    public Optional<ChallengeCache> getChallengerCache(UUID key) {
        return Optional.ofNullable(this.challengerCache.get(key));
    }

    public void removeChallengerCache(UUID key) {
        this.challengerCache.remove(key);
        this.func_76185_a();
    }

    public void tick(ServerWorld world) {
        InProgressChallenge challenge = this.getInProgressChallengeFor(world);
        if (challenge == null) {
            return;
        }
        if (challenge.canDelete()) {
            this.stopChallenge(challenge);
            return;
        }
        challenge.tick();
    }
}

