/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.world;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.poi.CountdownEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.NTEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.POIEventTarget;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.NPCWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.CaptainEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.GruntEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.NotoriousEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.PacifistaEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class EventsWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi-events";
    private static final int MAX_NOTORIOUS_TARGETS = 5;
    private static final int MAX_CARAVANS = 25;
    private static final int MAX_CELESTIAL_VISITS = 10;
    private Set<NTEventTarget> notoriousTarget = new HashSet<NTEventTarget>();
    private Set<POIEventTarget> caravans = new HashSet<POIEventTarget>();
    private Set<CountdownEventTarget> busterCalls = new HashSet<CountdownEventTarget>();
    private Set<POIEventTarget> celestialVisits = new HashSet<POIEventTarget>();
    private int tick = 0;

    public EventsWorldData() {
        super(IDENTIFIER);
    }

    @Nullable
    public static EventsWorldData get() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (EventsWorldData)ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x().func_215752_a(EventsWorldData::new, IDENTIFIER);
        }
        return null;
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT notoriousTargets = new ListNBT();
        for (POIEventTarget pOIEventTarget : this.notoriousTarget) {
            notoriousTargets.add((Object)pOIEventTarget.save());
        }
        nbt.func_218657_a("notoriousTargets", (INBT)notoriousTargets);
        ListNBT caravans = new ListNBT();
        for (POIEventTarget pOIEventTarget : this.caravans) {
            caravans.add((Object)pOIEventTarget.save());
        }
        nbt.func_218657_a("caravans", (INBT)caravans);
        ListNBT listNBT = new ListNBT();
        for (CountdownEventTarget poi : this.busterCalls) {
            listNBT.add((Object)poi.save());
        }
        nbt.func_218657_a("busterCalls", (INBT)listNBT);
        ListNBT listNBT2 = new ListNBT();
        for (POIEventTarget poi : this.celestialVisits) {
            listNBT2.add((Object)poi.save());
        }
        nbt.func_218657_a("celestialVisits", (INBT)listNBT2);
        return nbt;
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT notoriousTargets = nbt.func_150295_c("notoriousTargets", 10);
        for (int i = 0; i < notoriousTargets.size(); ++i) {
            CompoundNBT entryNBT = notoriousTargets.func_150305_b(i);
            if (entryNBT.isEmpty()) continue;
            NTEventTarget poi = new NTEventTarget();
            poi.load(entryNBT);
            this.notoriousTarget.add(poi);
        }
        ListNBT caravans = nbt.func_150295_c("caravans", 10);
        for (int i = 0; i < caravans.size(); ++i) {
            CompoundNBT entryNBT = caravans.func_150305_b(i);
            if (entryNBT.isEmpty()) continue;
            POIEventTarget poi = new POIEventTarget();
            this.setupCaravan(poi);
            poi.load(entryNBT);
            this.caravans.add(poi);
        }
        ListNBT busterCalls = nbt.func_150295_c("busterCalls", 10);
        for (int i = 0; i < busterCalls.size(); ++i) {
            CompoundNBT entryNBT = busterCalls.func_150305_b(i);
            if (entryNBT.isEmpty()) continue;
            CountdownEventTarget poi = new CountdownEventTarget();
            this.setupSpecialBusterCall(poi, poi.getTargetId());
            poi.load(entryNBT);
            this.busterCalls.add(poi);
        }
        ListNBT visits = nbt.func_150295_c("celestialVisits", 10);
        for (int i = 0; i < visits.size(); ++i) {
            CompoundNBT entryNBT = visits.func_150305_b(i);
            if (entryNBT.isEmpty()) continue;
            POIEventTarget poi = new POIEventTarget();
            this.setupCelestialVisit(poi);
            poi.load(entryNBT);
            this.celestialVisits.add(poi);
        }
    }

    public void tick(ServerWorld world) {
        ++this.tick;
        this.tickEvents(world);
        this.startNewEvents(world);
    }

    public void startNewEvents(ServerWorld world) {
        if (this.tick % 300 == 0) {
            Optional<Vector3d> opt;
            List players = world.func_217369_A();
            Collections.shuffle(players);
            if (CommonConfig.INSTANCE.canSpawnCelestialVisits()) {
                boolean canSpawnCelestialVisit;
                int newVisits = 0;
                boolean bl = canSpawnCelestialVisit = world.field_73012_v.nextInt(3) == 0;
                if (canSpawnCelestialVisit && this.celestialVisits.size() < 10) {
                    for (ServerPlayerEntity player : players) {
                        if (newVisits > 1) break;
                        opt = this.findEventPositionAround(world, player.func_213303_ch(), 100, 1000, false);
                        if (!opt.isPresent() || !this.canSpawnCVPoint(opt.get()) || !this.addCelestialVisit(world, opt.get())) continue;
                        ++newVisits;
                    }
                }
            }
            if (CommonConfig.INSTANCE.canSpawnCaravans()) {
                int newCaravans = 0;
                if (this.caravans.size() < 25) {
                    for (ServerPlayerEntity player : players) {
                        if (newCaravans > 3) break;
                        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
                        if (props.isMarine() || props.isBountyHunter() || !(opt = this.findEventPositionAround(world, player.func_213303_ch(), 500, 2500, false)).isPresent() || !this.addCaravan(world, opt.get(), 72000L)) continue;
                        ++newCaravans;
                    }
                }
            }
            if (CommonConfig.INSTANCE.canSpawnNotoriousTargets()) {
                NPCWorldData npcWorldData = NPCWorldData.get();
                int newTargets = 0;
                if (this.notoriousTarget.size() < 5) {
                    for (ServerPlayerEntity player : players) {
                        boolean isMarine;
                        Optional<TrackedNPC> npc;
                        if (newTargets > 2) break;
                        opt = this.findEventPositionAround(world, player.func_213303_ch(), 500, 2500, false);
                        if (!opt.isPresent() || !(npc = npcWorldData.getRandomTrackedMob((isMarine = world.func_201674_k().nextBoolean()) ? ModValues.MARINE : ModValues.PIRATE)).isPresent() || this.hasNTEventFor(npc.get())) continue;
                        this.addNotoriousTarget(world, opt.get(), 72000L, npc.get());
                        ++newTargets;
                    }
                }
            }
        }
    }

    public void tickEvents(ServerWorld world) {
        boolean hasUpdates = false;
        Iterator<NTEventTarget> ntIter = this.notoriousTarget.iterator();
        while (ntIter.hasNext()) {
            NTEventTarget poi = ntIter.next();
            if (poi.getTrackedNPC() != null) continue;
            ntIter.remove();
            hasUpdates = true;
        }
        Iterator eventsIter = Iterators.concat((Iterator[])new Iterator[]{this.busterCalls.iterator()});
        if (CommonConfig.INSTANCE.canSpawnNotoriousTargets()) {
            eventsIter = Iterators.concat((Iterator)eventsIter, this.notoriousTarget.iterator());
        }
        if (CommonConfig.INSTANCE.canSpawnCelestialVisits()) {
            eventsIter = Iterators.concat((Iterator)eventsIter, this.celestialVisits.iterator());
        }
        if (CommonConfig.INSTANCE.canSpawnCaravans()) {
            eventsIter = Iterators.concat((Iterator)eventsIter, this.caravans.iterator());
        }
        while (eventsIter.hasNext()) {
            POIEventTarget poi = (POIEventTarget)eventsIter.next();
            if (poi.hasExpired(world)) {
                eventsIter.remove();
                hasUpdates = true;
                continue;
            }
            for (ServerPlayerEntity player : world.func_217369_A()) {
                if (!poi.shouldTrigger(player)) continue;
                poi.getTriggerAction().trigger(world, poi);
                eventsIter.remove();
                hasUpdates = true;
                return;
            }
            poi.tick();
        }
        if (hasUpdates) {
            this.func_76185_a();
        }
    }

    public Optional<Vector3d> findEventPositionAround(ServerWorld world, Vector3d pos, int offsetXZ, int bonusOffsetXZ, boolean allowOceans) {
        Optional<Vector3d> pos2 = Optional.empty();
        for (int j = 0; j < 5; ++j) {
            Biome.Category category;
            int extraX = offsetXZ + world.func_201674_k().nextInt(bonusOffsetXZ);
            if (world.func_201674_k().nextBoolean()) {
                extraX *= -1;
            }
            int extraZ = offsetXZ + world.func_201674_k().nextInt(bonusOffsetXZ);
            if (world.func_201674_k().nextBoolean()) {
                extraZ *= -1;
            }
            Vector3d vecPos = pos.func_72441_c((double)extraX, 1.0, (double)extraZ);
            BlockPos check = new BlockPos(vecPos.field_72450_a, vecPos.field_72448_b, vecPos.field_72449_c);
            if (!allowOceans && (category = world.func_226691_t_(check).func_201856_r()) == Biome.Category.OCEAN) continue;
            pos2 = Optional.of(vecPos);
            break;
        }
        return pos2;
    }

    public boolean addCelestialVisit(ServerWorld world, Vector3d pos) {
        POIEventTarget poi = new POIEventTarget(world, pos, 72000L);
        this.setupCelestialVisit(poi);
        this.celestialVisits.add(poi);
        this.func_76185_a();
        return true;
    }

    private void setupCelestialVisit(POIEventTarget poi) {
        poi.setTriggerAction((world, event) -> {
            int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)event.getPosition().func_82615_a(), (int)event.getPosition().func_82616_c());
            BlockPos blockPos = new BlockPos(event.getPosition().func_82615_a(), (double)y, event.getPosition().func_82616_c());
            EntityType dragonEntity = (EntityType)ModEntities.CELESTIAL_DRAGON.get();
            EntityType gruntEntity = (EntityType)ModEntities.MARINE_GRUNT.get();
            dragonEntity.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, blockPos, SpawnReason.EVENT, false, false);
            for (int i = 0; i < 6; ++i) {
                gruntEntity.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, blockPos, SpawnReason.EVENT, false, false);
            }
        });
    }

    private boolean canSpawnCVPoint(Vector3d pos) {
        for (POIEventTarget poi : this.celestialVisits) {
            if (!(Math.abs(poi.getPosition().func_72436_e(pos)) < 22500.0)) continue;
            return false;
        }
        return true;
    }

    public Set<POIEventTarget> getCelestialVisitsPOIs() {
        return new LinkedHashSet<POIEventTarget>(this.celestialVisits);
    }

    public void addSpecialBusterCall(ServerWorld world, LivingEntity target) {
        CountdownEventTarget poi = new CountdownEventTarget(world, target, 72000L, 10);
        this.setupSpecialBusterCall(poi, target.func_110124_au());
        this.busterCalls.add(poi);
        this.func_76185_a();
    }

    private void setupSpecialBusterCall(CountdownEventTarget poi, UUID targetId) {
        poi.setTriggerAction((world, event) -> {
            int i;
            boolean canSpawnInBiome;
            Vector3d targetVec = event.getPosition();
            BlockPos targetPos = new BlockPos(targetVec);
            boolean bl = canSpawnInBiome = world.func_226691_t_(targetPos).func_201856_r() != Biome.Category.OCEAN;
            if (!canSpawnInBiome) {
                return;
            }
            Optional<TrackedNPC> viceAdmiralEntity = NPCWorldData.get().getRandomTrackedMob(ModValues.MARINE);
            EntityType captainEntity = (EntityType)ModEntities.MARINE_CAPTAIN.get();
            EntityType pacifistaEntity = (EntityType)ModEntities.PACIFISTA.get();
            EntityType gruntEntity = (EntityType)ModEntities.MARINE_GRUNT.get();
            boolean hasPacifistas = world.field_73012_v.nextInt(3) == 0;
            LivingEntity target = poi.getTarget(world).orElse(null);
            BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, captainEntity, targetPos, 10);
            if (spawnPos == null) {
                int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)event.getPosition().func_82615_a(), (int)event.getPosition().func_82616_c());
                spawnPos = new BlockPos(event.getPosition().func_82615_a(), (double)y, event.getPosition().func_82616_c());
            }
            if (viceAdmiralEntity.isPresent()) {
                Vector3d spawnVec = new Vector3d((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
                NotoriousEntity viceAdmiral = viceAdmiralEntity.get().spawnTrackedMob(world, spawnVec);
                if (viceAdmiral != null) {
                    viceAdmiral.func_70624_b(target);
                }
            }
            for (i = 0; i < 4; ++i) {
                spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, gruntEntity, targetPos, 20);
                if (spawnPos == null) continue;
                if (hasPacifistas) {
                    PacifistaEntity pacifista = (PacifistaEntity)pacifistaEntity.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
                    if (pacifista == null) continue;
                    pacifista.func_70624_b(target);
                    continue;
                }
                CaptainEntity captain = (CaptainEntity)captainEntity.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
                if (captain == null) continue;
                captain.func_70624_b(target);
            }
            for (i = 0; i < 20; ++i) {
                GruntEntity grunt;
                spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, gruntEntity, targetPos, 20);
                if (spawnPos == null || (grunt = (GruntEntity)gruntEntity.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false)) == null) continue;
                grunt.setFear(false);
                grunt.func_70624_b(target);
            }
            world.func_184133_a(null, targetPos, SoundEvents.field_219603_Y, SoundCategory.HOSTILE, 1.0f, 1.0f);
            world.func_184133_a(null, targetPos, (SoundEvent)ModSounds.GENERIC_EXPLOSION.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        });
    }

    public boolean addCaravan(ServerWorld world, Vector3d pos, long openTime) {
        BlockPos blockPos = new BlockPos(pos);
        Biome.Category category = world.func_226691_t_(blockPos).func_201856_r();
        if (category != Biome.Category.PLAINS && category != Biome.Category.FOREST) {
            return false;
        }
        if (!WyHelper.isSurfaceFlat((IWorld)world, blockPos.func_177958_n(), blockPos.func_177952_p(), 1)) {
            return false;
        }
        for (POIEventTarget poi : this.caravans) {
            if (!(poi.getPosition().func_72436_e(pos) < 2500.0)) continue;
            return false;
        }
        POIEventTarget poi = new POIEventTarget(world, pos, openTime);
        this.setupCaravan(poi);
        this.caravans.add(poi);
        this.func_76185_a();
        return true;
    }

    private void setupCaravan(POIEventTarget poi) {
        poi.setTriggerAction((world, event) -> {
            OPEntity entity;
            Optional<TrackedNPC> trackedNpc;
            BlockPos blockPos;
            int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)event.getPosition().func_82615_a(), (int)event.getPosition().func_82616_c());
            BlockPos enemiesSpawn = blockPos = new BlockPos(event.getPosition().func_82615_a(), (double)y, event.getPosition().func_82616_c());
            int grunts = 2 + world.func_201674_k().nextInt(5);
            boolean hasViceAdmiral = world.func_201674_k().nextInt(3) == 0;
            boolean hasPacifista = false;
            if (hasViceAdmiral) {
                grunts += 5;
                if (world.func_201674_k().nextInt(3) == 0) {
                    hasPacifista = true;
                }
            }
            if (!(trackedNpc = NPCWorldData.get().getRandomTrackedMob(ModValues.MARINE)).isPresent()) {
                hasViceAdmiral = false;
            }
            PlacementSettings placement = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
            placement.func_215219_b().func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c).func_189950_a(new Random(Util.func_211177_b()));
            Optional<Template> template = WyHelper.getNBTStructure(world, "unaligned/caravan", placement);
            if (template.isPresent()) {
                BlockPos templatePos = blockPos.func_177977_b();
                template.get().func_237144_a_((IServerWorld)world, templatePos, placement, new Random(Util.func_211177_b()));
                for (Template.BlockInfo blockInfo : template.get().func_215381_a(templatePos, placement, Blocks.field_185779_df)) {
                    StructureMode structuremode;
                    if (blockInfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)blockInfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
                    String function = blockInfo.field_186244_c.func_74779_i("metadata");
                    BlockPos functionPos = blockInfo.field_186242_a;
                    if (function.equals("caravan_loot")) {
                        StructuresHelper.spawnLoot((IWorld)world, functionPos, hasViceAdmiral ? ModLootTables.HARD_CARAVAN_CHEST : ModLootTables.EASY_CARAVAN_CHEST);
                        continue;
                    }
                    if (!function.equals("caravan_spawn")) continue;
                    enemiesSpawn = functionPos;
                }
            }
            for (int i = 0; i < grunts; ++i) {
                GruntEntity entity2 = (GruntEntity)((EntityType)ModEntities.MARINE_GRUNT.get()).func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, enemiesSpawn, SpawnReason.EVENT, false, false);
                if (entity2 == null) continue;
                entity2.setFear(false);
            }
            if (hasViceAdmiral) {
                entity = trackedNpc.get().createTrackedMob((World)world);
                entity.func_70107_b(enemiesSpawn.func_177958_n(), enemiesSpawn.func_177956_o(), enemiesSpawn.func_177952_p());
                world.func_217376_c((Entity)entity);
            } else {
                entity = (CaptainEntity)((EntityType)ModEntities.MARINE_CAPTAIN.get()).func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, enemiesSpawn, SpawnReason.EVENT, false, false);
                if (entity != null) {
                    entity.setFear(false);
                }
            }
            if (hasPacifista && (entity = (PacifistaEntity)((EntityType)ModEntities.PACIFISTA.get()).func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, enemiesSpawn, SpawnReason.EVENT, false, false)) != null) {
                entity.setFear(false);
            }
            for (int i = 0; i < 3; ++i) {
                EntityType.field_200756_av.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, enemiesSpawn, SpawnReason.EVENT, false, false);
            }
        });
    }

    public Set<POIEventTarget> getCaravanPOIs() {
        return new LinkedHashSet<POIEventTarget>(this.caravans);
    }

    public void addNotoriousTarget(ServerWorld world, Vector3d pos, long openTime, TrackedNPC tracked) {
        NPCWorldData.get().updateTrackedMob(world, tracked);
        NTEventTarget poi = new NTEventTarget(world, pos, openTime, tracked);
        this.notoriousTarget.add(poi);
        this.func_76185_a();
    }

    public Set<NTEventTarget> getNotoriousTargets() {
        return new LinkedHashSet<NTEventTarget>(this.notoriousTarget);
    }

    public boolean hasNTEventAt(Vector3d pos) {
        return this.notoriousTarget.stream().anyMatch(event -> event.getPosition().equals((Object)pos));
    }

    public boolean hasNTEventFor(TrackedNPC npc) {
        return this.notoriousTarget.stream().anyMatch(event -> event.getTrackedNPC().equals(npc));
    }

    public boolean hasNTEventFor(UUID id) {
        return this.notoriousTarget.stream().filter(event -> event.getTrackedNPC() != null).anyMatch(event -> event.getTrackedNPC().getUUID().equals(id));
    }
}

