/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.world;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NPCWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi-npcs";
    private Random random = new Random();
    private Interval updateInterval = Interval.startAtMax(300);
    private Interval updateNewsInterval = Interval.startAtMax(24000);
    private Set<TrackedNPC> tracked = new LinkedHashSet<TrackedNPC>();
    private long trackedId = 0L;

    public NPCWorldData() {
        super(IDENTIFIER);
    }

    @Nullable
    public static NPCWorldData get() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (NPCWorldData)ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x().func_215752_a(NPCWorldData::new, IDENTIFIER);
        }
        return null;
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        nbt.func_74772_a("globalTrackedId", this.trackedId);
        ListNBT trackedNpcs = new ListNBT();
        for (TrackedNPC npc : this.tracked) {
            trackedNpcs.add((Object)npc.save());
        }
        nbt.func_218657_a("trackedNPCs", (INBT)trackedNpcs);
        return nbt;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.trackedId = nbt.func_74763_f("globalTrackedId");
        ListNBT trackedNpcs = nbt.func_150295_c("trackedNPCs", 10);
        for (int i = 0; i < trackedNpcs.size(); ++i) {
            CompoundNBT entryNBT = trackedNpcs.func_150305_b(i);
            if (entryNBT.isEmpty()) continue;
            TrackedNPC npc = TrackedNPC.from(entryNBT);
            this.tracked.add(npc);
        }
    }

    public void setup(ServerWorld world) {
        int alivePirates = (int)this.tracked.stream().filter(t -> t.isPirate()).count();
        int aliveMarines = (int)this.tracked.stream().filter(t -> t.isMarine()).count();
        if (alivePirates <= 0) {
            for (int pirates = Math.abs(5 + world.func_201674_k().nextInt(10) - alivePirates); pirates > 0; --pirates) {
                this.addRandomTrackedMob(world, ModValues.PIRATE);
            }
        }
        if (aliveMarines <= 0) {
            for (int marines = Math.abs(5 + world.func_201674_k().nextInt(15) - aliveMarines); marines > 0; --marines) {
                this.addRandomTrackedMob(world, ModValues.MARINE);
            }
        }
    }

    public void tick(ServerWorld world) {
        int updates = 0;
        if (this.updateInterval.canTick()) {
            for (TrackedNPC tracked : this.tracked) {
                tracked.recalculateDifficulty(world);
                ++updates;
            }
        }
        if (this.updateNewsInterval.canTick()) {
            for (TrackedNPC tracked : this.tracked) {
                tracked.updateNewsEntry((World)world);
                ++updates;
            }
        }
        if (updates > 0) {
            this.func_76185_a();
        }
    }

    public Set<TrackedNPC> getTrackedMobs() {
        return new LinkedHashSet<TrackedNPC>(this.tracked);
    }

    public void updateTrackedMob(ServerWorld world, TrackedNPC npc) {
        npc.recalculateDifficulty(world);
        this.func_76185_a();
    }

    private void addRandomTrackedMob(ServerWorld world, ResourceLocation faction) {
        long seed = world.func_201674_k().nextLong();
        this.addTrackedMob(world, faction, seed);
    }

    private void addTrackedMob(ServerWorld world, ResourceLocation faction, long seed) {
        TrackedNPC tracked = new TrackedNPC(world, this.trackedId++, faction, seed);
        this.tracked.add(tracked);
        this.func_76185_a();
    }

    public void removeTrackedMob(ServerWorld world, TrackedNPC tracked) {
        if (tracked == null) {
            return;
        }
        this.tracked.remove(tracked);
        long factionLeft = this.tracked.stream().filter(npc -> npc.getFaction().equals((Object)tracked.getFaction())).count();
        if (factionLeft < 5L) {
            this.addRandomTrackedMob(world, tracked.getFaction());
        }
        this.func_76185_a();
    }

    public Optional<TrackedNPC> getTrackedMob(long id) {
        return this.tracked.stream().filter(t -> t.getId() == id).findFirst();
    }

    public Optional<TrackedNPC> getTrackedMob(UUID id) {
        return this.tracked.stream().filter(t -> t.getUUID().equals(id)).findFirst();
    }

    public Optional<TrackedNPC> getTrackedMobBySeed(long seed) {
        return this.tracked.stream().filter(t -> t.getSeed() == seed).findFirst();
    }

    public Optional<TrackedNPC> getRandomTrackedMob(ResourceLocation faction) {
        return Optional.ofNullable(this.tracked.stream().filter(npc -> npc.getFaction().equals((Object)faction)).collect(WyHelper.toShuffledList()).get(0));
    }
}

