/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.world;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;

public class ProtectedAreasData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi-protected-areas";
    private HashMap<String, ProtectedArea> abilityProtections = new HashMap();

    public ProtectedAreasData() {
        super(IDENTIFIER);
    }

    public ProtectedAreasData(String identifier) {
        super(identifier);
    }

    @Nullable
    public static ProtectedAreasData get(World level) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (ProtectedAreasData)ServerLifecycleHooks.getCurrentServer().func_71218_a(level.func_234923_W_()).func_217481_x().func_215752_a(ProtectedAreasData::new, IDENTIFIER);
        }
        return null;
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT protectedAreas = new ListNBT();
        if (this.abilityProtections.size() > 0) {
            for (Map.Entry<String, ProtectedArea> entry : this.abilityProtections.entrySet()) {
                CompoundNBT entryNBT = entry.getValue().save();
                protectedAreas.add((Object)entryNBT);
            }
        }
        nbt.func_218657_a("protectedAreas", (INBT)protectedAreas);
        return nbt;
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT protectedAreas = nbt.func_150295_c("protectedAreas", 10);
        this.abilityProtections.clear();
        for (int i = 0; i < protectedAreas.size(); ++i) {
            CompoundNBT entryNBT = protectedAreas.func_150305_b(i);
            ProtectedArea area = ProtectedArea.from(entryNBT);
            this.abilityProtections.put(area.getLabel(), area);
        }
    }

    public boolean isInsideRestrictedArea(int posX, int posY, int posZ) {
        if (this.abilityProtections.size() <= 0) {
            return false;
        }
        for (ProtectedArea area : this.abilityProtections.values()) {
            if (!area.isInside(posX, posY, posZ)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ProtectedArea getProtectedArea(String label) {
        return this.abilityProtections.get(label);
    }

    @Nullable
    public ProtectedArea getProtectedArea(int posX, int posY, int posZ) {
        for (ProtectedArea area : this.abilityProtections.values()) {
            if (!area.isInside(posX, posY, posZ)) continue;
            return area;
        }
        return null;
    }

    public void addRestrictedArea(ProtectedArea area) {
        this.abilityProtections.put(area.getLabel(), area);
        this.func_76185_a();
    }

    public void addRestrictedArea(BlockPos center, int size, String label) {
        ProtectedArea area = new ProtectedArea(center, size, label);
        this.abilityProtections.put(area.getLabel(), area);
        this.func_76185_a();
    }

    public void resizeRestrictedArea(String label, int size) {
        this.abilityProtections.get(label).setSize(size);
        this.func_76185_a();
    }

    public void removeRestrictedArea(String label) {
        this.abilityProtections.remove(label);
        this.func_76185_a();
    }

    public void removeRestrictedArea(int midX, int midY, int midZ) {
        for (ProtectedArea area : this.abilityProtections.values()) {
            if (midX != area.getCenter().func_177958_n() || midY != area.getCenter().func_177956_o() || midZ != area.getCenter().func_177952_p()) continue;
            this.abilityProtections.remove(area.getLabel());
            this.func_76185_a();
            return;
        }
    }

    public Map<String, ProtectedArea> getAllRestrictions() {
        return Collections.unmodifiableMap(this.abilityProtections);
    }
}

