/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.world;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class StructuresWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi-structures";
    private Set<BlockPos> snowMountains = new HashSet<BlockPos>();
    private Set<BlockPos> hugeSabaodyTrees = new HashSet<BlockPos>();

    public StructuresWorldData() {
        super(IDENTIFIER);
    }

    @Nullable
    public static StructuresWorldData get() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (StructuresWorldData)ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x().func_215752_a(StructuresWorldData::new, IDENTIFIER);
        }
        return null;
    }

    public void func_76184_a(CompoundNBT nbt) {
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        return nbt;
    }

    public void addSnowMountain(BlockPos pos) {
        this.snowMountains.add(pos);
    }

    public boolean isNearSnowMountain(BlockPos pos, double radius) {
        for (BlockPos checkPos : this.snowMountains) {
            if (!(checkPos.func_177951_i((Vector3i)pos) < radius * radius)) continue;
            return true;
        }
        return false;
    }

    public int countSnowMountains() {
        return this.snowMountains.size();
    }

    public void addHugeSabaodyTree(BlockPos pos) {
        this.hugeSabaodyTrees.add(pos);
    }

    public boolean isNearHugeSabaodyTree(BlockPos pos, double radius) {
        for (BlockPos checkPos : this.hugeSabaodyTrees) {
            if (!(checkPos.func_177951_i((Vector3i)pos) < radius * radius)) continue;
            return true;
        }
        return false;
    }

    public int countHugeSabaodyTree() {
        return this.hugeSabaodyTrees.size();
    }
}

