/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.datagen.loottables;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.CampLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.GhostShipLootTables;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.TavernLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.bandit.BanditLargeBaseLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.bandit.BanditSmallBaseLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.caravan.EasyCaravanLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.caravan.HardCaravanLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.marine.MarineBattleshipLootTables;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.marine.MarineLargeBaseLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.marine.MarineSmallBaseLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.pirate.PirateLargeShipLootTables;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.pirate.PirateMediumShipLootTables;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.pirate.PirateSmallShipLootTables;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.AbandonedMineshaftLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.BuriedTreasureLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.DesertPyramidLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.JungleTempleLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.PillagerOutpostLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.ShipwreckLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.SpawnBonusChestLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.StrongholdLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.UnderwaterRuinLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.WoodlandMansionLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.village.VillageArmorerLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.village.VillageButcherLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.village.VillageFisherLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.village.VillageFletcherLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.village.VillageShepherdLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.village.VillageTanneryLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.village.VillageTempleLootTable;
import xyz.pixelatedw.mineminenomi.datagen.loottables.structures.vanilla.village.VillageWeaponsmithLootTable;
import xyz.pixelatedw.mineminenomi.init.ModStructures;
import xyz.pixelatedw.mineminenomi.wypi.LootTablesDataGen;

public class StructuresLootTablesDataGen
extends LootTablesDataGen {
    private final Multimap<ResourceLocation, Pair<String, LootTable.Builder>> lootTables = HashMultimap.create();
    private final Multimap<ResourceLocation, LootTable.Builder> vanillaTables = HashMultimap.create();
    public static final ResourceLocation CARAVAN = new ResourceLocation("mineminenomi", "caravan");

    public StructuresLootTablesDataGen(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addLootTable((Structure)ModStructures.PIRATE_SMALL_SHIP.get(), PirateSmallShipLootTables.getTables());
        this.addLootTable((Structure)ModStructures.PIRATE_MEDIUM_SHIP.get(), PirateMediumShipLootTables.getTables());
        this.addLootTable((Structure)ModStructures.PIRATE_LARGE_SHIP.get(), PirateLargeShipLootTables.getTables());
        this.addLootTable((Structure)ModStructures.MARINE_BATTLESHIP.get(), MarineBattleshipLootTables.getTables());
        this.addLootTable((Structure)ModStructures.GHOST_SHIP.get(), GhostShipLootTables.getTables());
        this.addLootTable((Structure)ModStructures.MARINE_SMALL_BASE.get(), MarineSmallBaseLootTable.getTables());
        this.addLootTable((Structure)ModStructures.MARINE_LARGE_BASE.get(), MarineLargeBaseLootTable.getTables());
        this.addLootTable((Structure)ModStructures.BANDIT_SMALL_BASE.get(), BanditSmallBaseLootTable.getTables());
        this.addLootTable((Structure)ModStructures.BANDIT_LARGE_BASE.get(), BanditLargeBaseLootTable.getTables());
        this.addLootTable((Structure)ModStructures.MARINE_CAMP.get(), CampLootTable.getTables());
        this.addLootTable((Structure)ModStructures.BANDIT_CAMP.get(), CampLootTable.getTables());
        this.addLootTable(CARAVAN, EasyCaravanLootTable.getTables());
        this.addLootTable(CARAVAN, HardCaravanLootTable.getTables());
        this.addLootTable((Structure)ModStructures.TAVERN.get(), TavernLootTable.getTables());
        this.addVanillaLootTable(LootTables.field_204115_q, UnderwaterRuinLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_204114_p, UnderwaterRuinLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_204773_u, ShipwreckLootTable.getTreasurePool());
        this.addVanillaLootTable(LootTables.field_204772_t, ShipwreckLootTable.getSupplyPool());
        this.addVanillaLootTable(LootTables.field_186424_f, AbandonedMineshaftLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_204312_r, BuriedTreasureLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_186429_k, DesertPyramidLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_186430_l, JungleTempleLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215813_K, PillagerOutpostLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_191192_o, WoodlandMansionLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_186420_b, SpawnBonusChestLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_186428_j, StrongholdLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215816_g, VillageArmorerLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215820_k, VillageButcherLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215822_m, VillageFisherLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215821_l, VillageFletcherLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215823_n, VillageTanneryLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215824_o, VillageTempleLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215814_e, VillageWeaponsmithLootTable.getPool());
        this.addVanillaLootTable(LootTables.field_215819_j, VillageShepherdLootTable.getPool());
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        this.lootTables.forEach((key, pair) -> {
            ResourceLocation res = new ResourceLocation(key.func_110624_b(), "chests/" + key.func_110623_a() + "/" + (String)pair.getLeft());
            tables.put(res, ((LootTable.Builder)pair.getRight()).func_216038_b());
        });
        this.writeTables(cache, tables);
        HashMap<ResourceLocation, LootTable> vanillaTables = new HashMap<ResourceLocation, LootTable>();
        this.vanillaTables.forEach((key, builder) -> vanillaTables.put((ResourceLocation)key, builder.func_216038_b()));
        this.writeTables(cache, vanillaTables);
    }

    protected void addLootTable(Structure<?> structure, Pair<String, LootTable.Builder>[] pairs) {
        ResourceLocation key = ForgeRegistries.STRUCTURE_FEATURES.getKey(structure);
        this.addLootTable(key, pairs);
    }

    protected void addLootTable(ResourceLocation id, Pair<String, LootTable.Builder>[] pairs) {
        for (Pair<String, LootTable.Builder> pair : pairs) {
            this.lootTables.put((Object)id, pair);
        }
    }

    protected void addVanillaLootTable(ResourceLocation key, LootTable.Builder builder) {
        this.vanillaTables.put((Object)key, (Object)builder);
    }

    @Override
    public String func_200397_b() {
        return "Structures Loot Pools";
    }
}

