/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.effects;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.effects.IColorOverlayEffect;
import xyz.pixelatedw.mineminenomi.api.effects.IDisableAbilitiesEffect;
import xyz.pixelatedw.mineminenomi.api.effects.ModEffect;
import xyz.pixelatedw.mineminenomi.data.entity.animation.AnimationDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.animation.IAnimationData;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.packets.server.SToggleAnimationPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class UnconsciousEffect
extends ModEffect
implements IColorOverlayEffect,
IDisableAbilitiesEffect {
    public UnconsciousEffect() {
        super(EffectType.HARMFUL, WyHelper.hexToRGB("#000000").getRGB());
        this.func_220304_a(Attributes.field_233821_d_, "0e091520-be78-40aa-9e74-22aa34f506cf", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a((Attribute)ForgeMod.SWIM_SPEED.get(), "71ada06a-e999-4408-9d43-6f205379b52a", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a((Attribute)ModAttributes.JUMP_HEIGHT.get(), "7cadbf47-441b-4cd8-b93f-4e0c1147c7c8", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a(Attributes.field_233825_h_, "21006ee0-bf00-4ef7-90b0-d6ba8c003a4f", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a((Attribute)ModAttributes.MINING_SPEED.get(), "7adfb66b-5442-4b9e-8a42-5b1e25c39226", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration % 15 == 0;
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        IAnimationData animationData = AnimationDataCapability.get(entity);
        if (animationData != null) {
            boolean isAnimationPlaying;
            boolean bl = isAnimationPlaying = animationData.isAnimationPlaying(ModAnimations.UNCONSCIOUS) || animationData.isAnimationPlaying(ModAnimations.UNCONSCIOUS_YAMCHA);
            if (!isAnimationPlaying) {
                EffectInstance instance = entity.func_70660_b((Effect)this);
                this.startAnimation(entity, instance);
            }
        }
    }

    @Override
    public void startEffect(LivingEntity entity, EffectInstance instance) {
        this.startAnimation(entity, instance);
    }

    private void startAnimation(LivingEntity entity, EffectInstance instance) {
        boolean hasSpecialAnimation;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        long seed = Math.round(Math.floor(entity.func_142015_aE()));
        int r = new Random(entity.func_110124_au().getMostSignificantBits() + seed).nextInt(5);
        boolean bl = hasSpecialAnimation = r == 0;
        if (entity instanceof PlayerEntity && hasSpecialAnimation) {
            WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.playAnimation(entity, ModAnimations.UNCONSCIOUS_YAMCHA, instance.func_76459_b(), true), (Entity)entity);
        } else {
            WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.playAnimation(entity, ModAnimations.UNCONSCIOUS, instance.func_76459_b(), true), (Entity)entity);
        }
    }

    @Override
    public void stopEffect(LivingEntity entity) {
        WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.stopAnimation(entity, ModAnimations.UNCONSCIOUS_YAMCHA), (Entity)entity);
        WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.stopAnimation(entity, ModAnimations.UNCONSCIOUS), (Entity)entity);
    }

    @Override
    public boolean shouldUpdateClient() {
        return true;
    }

    @Override
    public float[] getViewOverlayColor(int duration, int amplifier) {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    }

    @Override
    @Nullable
    public float[] getBodyOverlayColor(int duration, int amplifier) {
        return null;
    }

    @Override
    public boolean isBlockingRotations() {
        return true;
    }

    @Override
    public boolean isRemoveable() {
        return false;
    }

    @Override
    public boolean isBlockingSwings() {
        return true;
    }

    @Override
    public Predicate<IAbility> getDisabledAbilities() {
        return abl -> true;
    }
}

