/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModBiomes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BonChariEntity
extends Entity {
    private static final DataParameter<Integer> BURST_TIME = EntityDataManager.func_187226_a(BonChariEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int BUBBLE_BURST_TICKS = 30;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private float burstingAngle;
    private float burstingAngleO;

    public BonChariEntity(World level) {
        super((EntityType)ModEntities.BON_CHARI.get(), level);
        this.field_70156_m = true;
    }

    public BonChariEntity(EntityType<?> type, World level) {
        super(type, level);
        this.field_70156_m = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BURST_TIME, (Object)0);
    }

    public float getEyeHeightForge(Pose pPose, EntitySize pSize) {
        return pSize.field_220316_b;
    }

    public boolean func_241849_j(Entity entity) {
        return BonChariEntity.canVehicleCollide(this, entity);
    }

    public static boolean canVehicleCollide(Entity vehicle, Entity entity) {
        return (entity.func_241845_aY() || entity.func_70104_M()) && !vehicle.func_184223_x(entity);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public double func_70042_X() {
        return -0.1;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double y = this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W();
            Vector3d posVec = new Vector3d(-0.3, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + posVec.field_72450_a, y, this.func_226281_cx_() + posVec.field_72449_c);
        }
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYRot - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        int burstTime = this.getBurstTime();
        if (this.field_70170_p.field_72995_K) {
            float mul = 1.0f;
            mul = burstTime > 0 ? (mul += 0.05f) : 0.0f;
            mul = MathHelper.func_76131_a((float)mul, (float)0.0f, (float)1.0f);
            this.burstingAngleO = this.burstingAngle;
            this.burstingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * mul;
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean isInSaboandy;
            boolean bl = isInSaboandy = this.field_70170_p.func_226691_t_(this.func_233580_cy_()).getRegistryName().equals((Object)((Biome)ModBiomes.SABAODY.get()).getRegistryName()) && this.func_226278_cu_() < 140.0;
            if (!isInSaboandy) {
                this.setBurstTime(++burstTime);
                if (burstTime > 30) {
                    WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BON_CHARI_POPPING.get(), this, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_());
                    this.func_184226_ay();
                    this.func_70106_y();
                }
            } else if (burstTime > 0) {
                this.setBurstTime(0);
            }
        }
        this.tickLerp();
        super.func_70071_h_();
        if (this.func_184186_bw()) {
            Vector3d vector3d = this.func_213322_ci();
            if (this.func_184179_bs() == null) {
                double d1 = this.func_189652_ae() ? 0.0 : (double)-0.001f;
                AbilityHelper.setDeltaMovement(this, vector3d.field_72450_a, vector3d.field_72448_b + d1, vector3d.field_72449_c);
            } else {
                this.controlVehicle();
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
    }

    private void controlVehicle() {
        if (this.func_184207_aI()) {
            boolean isMoving;
            Entity passanger = this.func_184179_bs();
            if (passanger == null || !(passanger instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)passanger;
            float speed = 0.5f;
            boolean bl = isMoving = !(player.field_191988_bg > 0.0f);
            if (!isMoving) {
                Vector3d vec = player.func_70040_Z();
                double x = vec.field_72450_a * (double)speed;
                double y = vec.field_72448_b * (double)speed;
                double z = vec.field_72449_c * (double)speed;
                AbilityHelper.setDeltaMovement(this, x, y, z);
            } else {
                AbilityHelper.setDeltaMovement(this, Vector3d.field_186680_a);
            }
            if (player.field_191988_bg > 0.0f) {
                double yRot = MathHelper.func_76138_g((double)((double)this.field_70177_z * (Math.PI / 180))) + 0.8;
                double dist = 1.2;
                double xp = dist * Math.cos(yRot) - dist * Math.sin(yRot);
                double zp = dist * Math.cos(yRot) + dist * Math.sin(yRot);
                for (int i = 0; i < 5; ++i) {
                    double offsetX = WyHelper.randomDouble() / 2.5 - xp;
                    double offsetY = WyHelper.randomDouble() / 2.5;
                    double offsetZ = WyHelper.randomDouble() / 2.5 - zp;
                    SimpleParticleData proj = new SimpleParticleData((ParticleType)ModParticleTypes.AWA.get());
                    proj.setLife(10);
                    proj.setSize(2.0f);
                    proj.setMotion(-this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, -this.func_213322_ci().field_72449_c);
                    this.field_70170_p.func_195594_a((IParticleData)proj, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.65 + offsetY, this.func_226281_cx_() + offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_70018_K();
            this.func_70106_y();
            return true;
        }
        return true;
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof BonChariEntity) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    protected void clampRotation(Entity entity) {
        entity.func_181013_g(this.field_70177_z);
        float yRot = MathHelper.func_76142_g((float)(entity.field_70177_z - this.field_70177_z));
        float yRotClamp = MathHelper.func_76131_a((float)yRot, (float)-105.0f, (float)105.0f);
        entity.field_70126_B += yRotClamp - yRot;
        entity.field_70177_z += yRotClamp - yRot;
        entity.func_70034_d(entity.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entity) {
        this.field_70177_z = entity.field_70177_z;
        this.field_70125_A = entity.field_70125_A;
        this.clampRotation(entity);
    }

    private void setBurstTime(int burstTime) {
        this.field_70180_af.func_187227_b(BURST_TIME, (Object)burstTime);
    }

    private int getBurstTime() {
        return (Integer)this.field_70180_af.func_187225_a(BURST_TIME);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getBurstingAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.burstingAngleO, (float)this.burstingAngle);
    }

    protected void func_70037_a(CompoundNBT nbt) {
    }

    protected void func_213281_b(CompoundNBT nbt) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

