/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntities;

public class BottomHalfBodyEntity
extends OPEntity {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(BottomHalfBodyEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private Ability parentAbility = null;

    public BottomHalfBodyEntity(EntityType type, World world) {
        super(type, world);
    }

    public BottomHalfBodyEntity(World world) {
        this((EntityType)ModEntities.BOTTOM_HALF_BODY.get(), world);
    }

    public void setParentAbility(Ability ability) {
        this.parentAbility = ability;
    }

    public void setOwner(LivingEntity owner) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(owner.func_110124_au()));
        EntityStatsCapability.get((LivingEntity)this).setFaction(EntityStatsCapability.get(owner).getFaction());
        EntityStatsCapability.get((LivingEntity)this).setRace(EntityStatsCapability.get(owner).getRace());
        ForgeRegistries.ATTRIBUTES.forEach(attr -> {
            if (owner.func_110148_a(attr) != null && this.func_110148_a((Attribute)attr) != null) {
                double val = owner.func_110148_a(attr).func_111125_b();
                this.func_110148_a((Attribute)attr).func_111128_a(val);
            }
        });
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.3f);
        this.func_70606_j(owner.func_110143_aJ());
    }

    @Nullable
    public UUID getOwnerUUID() {
        if (((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent()) {
            return (UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get();
        }
        return null;
    }

    public LivingEntity getOwner() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        Optional ownerUUID = (Optional)this.func_184212_Q().func_187225_a(OWNER);
        if (ownerUUID.isPresent()) {
            PlayerEntity playerOwner = this.field_70170_p.func_217371_b((UUID)ownerUUID.get());
            if (playerOwner != null) {
                return playerOwner;
            }
            Entity entityOwner = ((ServerWorld)this.field_70170_p).func_217461_a((UUID)ownerUUID.get());
            if (entityOwner != null && entityOwner instanceof LivingEntity) {
                return (LivingEntity)entityOwner;
            }
        }
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        owner.func_70097_a(ModDamageSource.OUT_OF_BODY, amount);
        this.func_70606_j(owner.func_110143_aJ());
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        owner.func_70097_a(ModDamageSource.OUT_OF_BODY, owner.func_110138_aP());
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            IAbilityData abilityProps;
            Ability parentAbilityInstance;
            LivingEntity owner = this.getOwner();
            boolean hasParentAbilityActive = false;
            if (owner != null && (parentAbilityInstance = (abilityProps = AbilityDataCapability.get(owner)).getEquippedAbility(this.parentAbility)) != null && parentAbilityInstance.isContinuous()) {
                hasParentAbilityActive = true;
            }
            if (owner == null || !owner.func_70089_S() || this.parentAbility == null || !hasParentAbilityActive) {
                this.func_70106_y();
                return;
            }
            if (this.func_70032_d((Entity)this.getOwner()) > 5.0f) {
                this.func_70661_as().func_75497_a((Entity)this.getOwner(), 1.25);
            }
        }
        super.func_70071_h_();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER, Optional.empty());
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    public boolean func_70039_c(CompoundNBT compound) {
        if (((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent()) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()).toString());
        }
        return super.func_70039_c(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.func_184212_Q().func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
    }
}

