/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.entities.IVehicleAltMode;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CannonEntity
extends Entity
implements IVehicleAltMode {
    private static final DataParameter<Byte> MODE = EntityDataManager.func_187226_a(CannonEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final TranslationTextComponent GUNPOWDER_INFO = new TranslationTextComponent(ModI18n.INFO_NEEDS_GUNPOWDER_LOADED);
    private static final TranslationTextComponent CANNONBALL_INFO = new TranslationTextComponent(ModI18n.INFO_NEEDS_CANNONBALL_LOADED);
    private static final float MOVE_SPEED = 0.05f;
    private static final float BACKWARDS_MOVE_SPEED = -0.03f;
    private static final float YAW_AIM_SPEED = 1.0f;
    private static final float PITCH_AIM_SPEED = 1.0f;
    private static final float MOVEMENT_FRICTION = 0.1f;
    private static final float ROTATION_FRICTION = 0.1f;
    private static final float GRAVITY = -0.4f;
    private static final float DEFAULT_COOLDOWN = 10.0f;
    private static final byte HURT_EVENT = 100;
    private float deltaYaw;
    private float deltaPitch;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private float cooldown;
    private float damage;
    private int hurtTime;

    public CannonEntity(World level) {
        super((EntityType)ModEntities.CANNON.get(), level);
        this.field_70156_m = true;
    }

    public CannonEntity(EntityType<?> type, World level) {
        super(type, level);
        this.field_70156_m = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MODE, (Object)0);
    }

    public float getEyeHeightForge(Pose pose, EntitySize size) {
        return size.field_220316_b;
    }

    public boolean func_241849_j(Entity entity) {
        return CannonEntity.canVehicleCollide(this, entity);
    }

    public static boolean canVehicleCollide(Entity vehicle, Entity entity) {
        if (entity.func_226278_cu_() < vehicle.func_226278_cu_()) {
            return false;
        }
        return (entity.func_241845_aY() || entity.func_70104_M()) && !vehicle.func_184223_x(entity);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public double func_70042_X() {
        return 0.35;
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYRot - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        LivingEntity rider;
        super.func_70071_h_();
        this.tickLerp();
        if (this.cooldown > 0.0f) {
            this.cooldown -= 1.0f;
        }
        Entity passanger = this.func_184179_bs();
        if (!this.field_70170_p.field_72995_K && passanger != null && passanger instanceof LivingEntity && this.canShoot(rider = (LivingEntity)passanger)) {
            this.shootCannonball(rider);
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        double gravity = this.func_189652_ae() ? 0.0 : (double)-0.4f;
        Vector3d motion = this.func_213322_ci();
        AbilityHelper.setDeltaMovement(this, motion.field_72450_a * (double)0.1f, motion.field_72448_b + gravity, motion.field_72449_c * (double)0.1f);
        if (this.func_184186_bw()) {
            this.deltaYaw *= 0.1f;
            this.deltaPitch *= 0.1f;
            if (this.func_184179_bs() != null && this.func_184179_bs() instanceof LivingEntity) {
                this.controlVehicle();
            }
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (!this.func_233570_aj_()) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(0.0, -1.0, 0.0)));
            for (Entity entity : list) {
                entity.func_70097_a(DamageSource.field_82728_o, 20.0f);
            }
        }
    }

    private void controlVehicle() {
        if (this.func_184207_aI()) {
            Entity passanger = this.func_184179_bs();
            if (passanger == null || !(passanger instanceof LivingEntity)) {
                return;
            }
            LivingEntity player = (LivingEntity)passanger;
            if (player.field_70702_br > 0.0f) {
                this.deltaYaw -= 1.0f;
            } else if (player.field_70702_br < 0.0f) {
                this.deltaYaw += 1.0f;
            }
            float speed = 0.0f;
            if (this.isMoveMode()) {
                if (player.field_191988_bg > 0.0f) {
                    speed = 0.05f;
                } else if (player.field_191988_bg < 0.0f) {
                    speed = -0.03f;
                }
            } else if (this.isAimMode()) {
                if (player.field_191988_bg > 0.0f && this.field_70125_A > -50.0f) {
                    this.deltaPitch -= 1.0f;
                } else if (player.field_191988_bg < 0.0f && this.field_70125_A < 0.0f) {
                    this.deltaPitch += 1.0f;
                }
            }
            this.field_70177_z += this.deltaYaw;
            this.field_70125_A += this.deltaPitch;
            AbilityHelper.setDeltaMovement(this, this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * speed), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * speed)));
        }
    }

    public boolean canShoot(LivingEntity rider) {
        if (this.func_184207_aI()) {
            boolean canShoot = false;
            boolean hasInfiniteAmmo = false;
            ItemStack cannonballStack = ItemStack.field_190927_a;
            int cannonballCount = 0;
            ItemStack gunpowderStack = ItemStack.field_190927_a;
            int gunpowderCount = 0;
            hasInfiniteAmmo = rider instanceof PlayerEntity ? ((PlayerEntity)rider).field_71075_bZ.field_75098_d : true;
            if (rider.field_110158_av == 1 && this.cooldown <= 0.0f) {
                if (hasInfiniteAmmo) {
                    canShoot = true;
                } else {
                    ItemStack itemstack;
                    int j;
                    List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(rider);
                    for (j = 0; j < inventory.size(); ++j) {
                        itemstack = inventory.get(j);
                        if (!itemstack.func_77973_b().equals(ModItems.CANNON_BALL.get())) continue;
                        cannonballStack = itemstack;
                        cannonballCount += itemstack.func_190916_E();
                    }
                    if (cannonballCount <= 0 || cannonballStack.func_190926_b()) {
                        rider.func_145747_a((ITextComponent)CANNONBALL_INFO, Util.field_240973_b_);
                        return false;
                    }
                    for (j = 0; j < inventory.size(); ++j) {
                        itemstack = inventory.get(j);
                        if (!itemstack.func_77973_b().equals(Items.field_151016_H)) continue;
                        gunpowderStack = itemstack;
                        gunpowderCount += itemstack.func_190916_E();
                    }
                    if (gunpowderCount <= 0 || gunpowderStack.func_190926_b()) {
                        rider.func_145747_a((ITextComponent)GUNPOWDER_INFO, Util.field_240973_b_);
                        return false;
                    }
                    if (cannonballCount > 0 && gunpowderCount > 0 && !cannonballStack.func_190926_b() && !gunpowderStack.func_190926_b()) {
                        canShoot = true;
                    }
                }
            }
            if (canShoot) {
                if (!hasInfiniteAmmo) {
                    cannonballStack.func_190918_g(1);
                    gunpowderStack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public void shootCannonball(LivingEntity rider) {
        CannonBallProjectile proj = new CannonBallProjectile(this.field_70170_p, rider);
        proj.func_70107_b(this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + 0.25, this.func_213303_ch().field_72449_c);
        proj.setDamage(30.0f);
        proj.setMaxLife(180);
        proj.setGravity(0.04f);
        this.field_70170_p.func_217376_c((Entity)proj);
        proj.func_234612_a_(this, this.field_70125_A, this.field_70177_z, 0.0f, 3.0f, 0.0f);
        rider.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ModSounds.GENERIC_EXPLOSION.get(), SoundCategory.PLAYERS, 2.5f, 0.75f + rider.func_70681_au().nextFloat() / 4.0f);
        this.cooldown = 10.0f;
        Vector3d lookVec = this.func_70040_Z().func_186678_a(4.0);
        for (int i = 0; i < 10; ++i) {
            double offsetX = WyHelper.randomDouble() / 2.0 + lookVec.field_72450_a;
            double offsetY = WyHelper.randomDouble() / 2.0;
            double offsetZ = WyHelper.randomDouble() / 2.0 + lookVec.field_72449_c;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)this.func_233580_cy_().func_177958_n() + offsetX, (double)(this.func_233580_cy_().func_177956_o() + 1) + offsetY, (double)this.func_233580_cy_().func_177952_p() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = -1.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vector3d vector3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vector3d.field_72449_c);
            passenger.field_70177_z += this.deltaYaw;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaYaw);
            this.clampRotation(passenger);
            if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    public Vector3d func_230268_c_(LivingEntity entity) {
        Vector3d lookVec = this.func_70040_Z().func_216371_e();
        return entity.func_213303_ch().func_72441_c(0.0, 0.5, 0.0).func_178787_e(lookVec);
    }

    @Override
    public void changeVehicleMode() {
        if (this.isAimMode()) {
            this.setMoveMode();
        } else {
            this.setAimMode();
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (hand.equals((Object)Hand.OFF_HAND)) {
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_184220_m((Entity)this)) {
                this.cooldown = 10.0f;
                return ActionResultType.CONSUME;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamage() > 50.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199701_a_(((Block)ModBlocks.CANNON.get()).func_199767_j().func_190903_i());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_203002_i(boolean isDownwards) {
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof CannonEntity) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 100: {
                this.hurtTime = 10;
            }
        }
        super.func_70103_a(id);
    }

    protected void clampRotation(Entity pEntityToUpdate) {
        pEntityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(pEntityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        pEntityToUpdate.field_70126_B += f1 - f;
        pEntityToUpdate.field_70177_z += f1 - f;
        pEntityToUpdate.func_70034_d(pEntityToUpdate.field_70177_z);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ((Block)ModBlocks.CANNON.get()).func_199767_j().func_190903_i();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity pEntityToUpdate) {
        this.clampRotation(pEntityToUpdate);
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.setModeByte(nbt.func_74771_c("mode"));
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74774_a("mode", this.getModeByte());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setAimMode() {
        this.setMode(Mode.AIM);
    }

    public void setMoveMode() {
        this.setMode(Mode.MOVE);
    }

    private void setMode(Mode mode) {
        this.setModeByte((byte)mode.ordinal());
    }

    private void setModeByte(byte mode) {
        this.field_70180_af.func_187227_b(MODE, (Object)mode);
    }

    public boolean isAimMode() {
        return this.getMode().equals((Object)Mode.AIM);
    }

    public boolean isMoveMode() {
        return this.getMode().equals((Object)Mode.MOVE);
    }

    private byte getModeByte() {
        return (Byte)this.field_70180_af.func_187225_a(MODE);
    }

    public Mode getMode() {
        return Mode.values()[(Byte)this.field_70180_af.func_187225_a(MODE)];
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public int getHurtTime() {
        return this.hurtTime;
    }

    public void setHurtTime(int hurtTime) {
        this.hurtTime = hurtTime;
    }

    public static enum Mode {
        AIM,
        MOVE;

    }
}

