/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEntities;

public class SpearEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> ID_LOYALTY = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> ID_FOIL = EntityDataManager.func_187226_a(SpearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private ItemStack itemStack;
    private float attackDamage;
    private boolean dealtDamage;
    public int clientSideReturnTickCount;

    public SpearEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public SpearEntity(PlayerEntity thrower, ItemStack stack) {
        super((EntityType)ModEntities.THROWING_SPEAR.get(), (LivingEntity)thrower, thrower.field_70170_p);
        this.itemStack = stack.func_77946_l();
        this.field_70180_af.func_187227_b(ID_LOYALTY, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)stack)));
        this.field_70180_af.func_187227_b(ID_FOIL, (Object)stack.func_77962_s());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ID_LOYALTY, (Object)0);
        this.field_70180_af.func_187214_a(ID_FOIL, (Object)false);
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && entity != null) {
            byte i = (Byte)this.field_70180_af.func_187225_a(ID_LOYALTY);
            if (i > 0 && !this.isAcceptibleReturnOwner()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else if (i > 0) {
                this.func_203045_n(true);
                Vector3d vector3d = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226280_cw_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015 * (double)i, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.05 * (double)i;
                AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
                if (this.clientSideReturnTickCount == 0) {
                    this.func_184185_a(SoundEvents.field_203270_il, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTickCount;
            }
        }
        super.func_70071_h_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            return !(entity instanceof ServerPlayerEntity) || !entity.func_175149_v();
        }
        return false;
    }

    public ItemStack func_184550_j() {
        return this.itemStack.func_77946_l();
    }

    public ItemStack getItemUsed() {
        return this.itemStack;
    }

    public void setAttackDamage(float damage) {
        this.attackDamage = damage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil() {
        return (Boolean)this.field_70180_af.func_187225_a(ID_FOIL);
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d pStartVec, Vector3d pEndVec) {
        return this.dealtDamage ? null : super.func_213866_a(pStartVec, pEndVec);
    }

    protected void func_213868_a(EntityRayTraceResult pResult) {
        BlockPos blockpos;
        Entity entity1;
        Entity entity = pResult.func_216348_a();
        float f = this.attackDamage;
        if (entity instanceof LivingEntity && !entity.field_70170_p.field_72995_K) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.func_152377_a((ItemStack)this.itemStack, (CreatureAttribute)livingentity.func_70668_bt());
        }
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)((entity1 = this.func_234616_v_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        if (entity.func_70097_a(damagesource, f)) {
            if (entity.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.func_184548_a(livingentity1);
            }
        }
        AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        if (this.field_70170_p instanceof ServerWorld && this.field_70170_p.func_72911_I() && EnchantmentHelper.func_203192_h((ItemStack)this.itemStack) && this.field_70170_p.func_226660_f_(blockpos = entity.func_233580_cy_())) {
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)blockpos));
            lightningboltentity.func_204809_d(entity1 instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity1 : null);
            this.field_70170_p.func_217376_c((Entity)lightningboltentity);
            soundevent = SoundEvents.field_203275_iq;
            f1 = 5.0f;
        }
        this.func_184185_a(soundevent, f1, 1.0f);
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70100_b_(PlayerEntity pEntity) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == pEntity.func_110124_au()) {
            super.func_70100_b_(pEntity);
        }
    }

    public void func_70037_a(CompoundNBT pCompound) {
        super.func_70037_a(pCompound);
        if (pCompound.func_150297_b("Item", 10)) {
            this.itemStack = ItemStack.func_199557_a((CompoundNBT)pCompound.func_74775_l("Item"));
        }
        this.dealtDamage = pCompound.func_74767_n("DealtDamage");
        this.field_70180_af.func_187227_b(ID_LOYALTY, (Object)((byte)EnchantmentHelper.func_203191_f((ItemStack)this.itemStack)));
    }

    public void func_213281_b(CompoundNBT pCompound) {
        super.func_213281_b(pCompound);
        pCompound.func_218657_a("Item", (INBT)this.itemStack.func_77955_b(new CompoundNBT()));
        pCompound.func_74757_a("DealtDamage", this.dealtDamage);
    }

    public void func_225516_i_() {
        byte i = (Byte)this.field_70180_af.func_187225_a(ID_LOYALTY);
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED || i <= 0) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double pX, double pY, double pZ) {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeItemStack(this.itemStack, false);
        buffer.writeInt(this.func_234616_v_() != null ? this.func_234616_v_().func_145782_y() : -1);
    }

    public void readSpawnData(PacketBuffer data) {
        this.itemStack = data.func_150791_c();
        int ownerId = data.readInt();
        if (ownerId >= 0) {
            this.func_212361_a(this.field_70170_p.func_73045_a(ownerId));
        }
    }
}

