/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhaseManager;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ClimbOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.MeleeRangedStyleSwitchGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.KaenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.KemuriBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.SakuretsuSabotenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.TetsuBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.TokuyoAburaBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SniperEntity
extends OPEntity
implements IRangedAttackMob,
ICommandReceiver {
    private static final ResourceLocation[] STYLES = new ResourceLocation[]{ModValues.SNIPER};
    private final NPCPhaseManager phaseManager = new NPCPhaseManager((MobEntity)this);
    private NPCPhase<SniperEntity> meleePhase;
    private NPCPhase<SniperEntity> rangePhase;
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;
    private LivingEntity lastTarget;
    private boolean firstShot = true;

    public SniperEntity(EntityType type, World world, ResourceLocation faction) {
        super(type, world, null);
        ResourceLocation style = STYLES[this.func_70681_au().nextInt(STYLES.length)];
        if (world != null && !world.field_72995_K) {
            this.meleePhase = new SimplePhase<SniperEntity>("Melee Phase", this);
            this.rangePhase = new SimplePhase<SniperEntity>("Range Phase", this);
            this.getEntityStats().setFaction(faction);
            this.getEntityStats().setFightingStyle(style);
            this.getEntityStats().setRace(ModValues.HUMAN);
            this.setDetails();
            boolean isHardDifficulty = this.isAboveNormalDifficulty();
            this.setDoriki(2000.0 + WyHelper.randomWithRange(0, 1500) + (isHardDifficulty ? WyHelper.randomWithRange(0, 500) : 0.0));
            this.setBelly(5.0 + WyHelper.randomWithRange(0, 5));
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(60.0);
            if (this.field_70170_p.func_175659_aa().func_151525_a() <= 2) {
                float mod = 1.0f;
                switch (this.field_70170_p.func_175659_aa()) {
                    case EASY: {
                        mod = 2.0f;
                        break;
                    }
                    case NORMAL: {
                        mod = 1.25f;
                        break;
                    }
                }
                ModifiableAttributeInstance attr = this.func_110148_a(Attributes.field_233819_b_);
                attr.func_111128_a(attr.func_111125_b() / (double)mod);
            }
            MobsHelper.addBasicNPCGoals(this);
            CommandAbility.addCommandGoals((MobEntity)this);
            this.field_70714_bg.func_75776_a(0, (Goal)new ClimbOutOfHoleGoal((MobEntity)this));
            this.meleePhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
            MobsHelper.addBusoshokuHaki((MobEntity)this, 15);
            this.phaseManager.setPhase(this.rangePhase);
        }
    }

    public static SniperEntity createMarineSniper(EntityType type, World world) {
        return new SniperEntity(type, world, ModValues.MARINE);
    }

    public static SniperEntity createMarineSniper(World world) {
        return new SniperEntity((EntityType)ModEntities.MARINE_SNIPER.get(), world, ModValues.MARINE);
    }

    public static SniperEntity createBanditSniper(EntityType type, World world) {
        return new SniperEntity(type, world, ModValues.BANDIT);
    }

    public static SniperEntity createBanditSniper(World world) {
        return new SniperEntity((EntityType)ModEntities.BANDIT_SNIPER.get(), world, ModValues.BANDIT);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, WyHelper.randomWithRange(2, 4)).func_233815_a_(Attributes.field_233818_a_, WyHelper.randomWithRange(30, 50)).func_233815_a_(Attributes.field_233826_i_, WyHelper.randomWithRange(1, 3));
    }

    private void onStyleSwitched(LivingEntity entity, boolean isRanged) {
        if (isRanged) {
            this.phaseManager.setPhase(this.rangePhase);
        } else {
            this.phaseManager.setPhase(this.meleePhase);
        }
    }

    @Override
    public void func_70619_bc() {
        this.phaseManager.tick();
    }

    public void func_82196_d(LivingEntity target, float velocity) {
        if (this.func_184614_ca() == null || !this.func_184614_ca().func_77973_b().equals(ModWeapons.SENRIKU.get())) {
            return;
        }
        if (this.func_70638_az() == null) {
            return;
        }
        if (this.lastTarget == null || this.lastTarget != this.func_70638_az()) {
            this.lastTarget = this.func_70638_az();
            this.firstShot = true;
        }
        boolean isHardDifficulty = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_193845_a((float)Difficulty.NORMAL.ordinal());
        AbilityProjectileEntity proj = new NormalBulletProjectile(this.field_70170_p, (LivingEntity)this);
        proj.setDamage(5.0f);
        if (isHardDifficulty) {
            proj = new KairosekiBulletProjectile(this.field_70170_p, (LivingEntity)this);
            proj.setDamage(7.0f);
        }
        if (this.firstShot) {
            proj.setDamage(-1.0f);
        }
        float inaccuracy = Math.max(0.0f, 6.0f - (float)this.field_70170_p.func_175659_aa().func_151525_a() * 2.5f);
        if (this.firstShot) {
            inaccuracy = 20.0f;
        }
        proj.func_234612_a_((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, 4.0f, inaccuracy);
        this.field_70170_p.func_217376_c((Entity)proj);
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ModSounds.SNIPER_SHOOT.get(), SoundCategory.PLAYERS, 3.0f, 0.75f + this.func_70681_au().nextFloat() / 4.0f);
        this.firstShot = false;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    private void setDetails() {
        IEntityStats props = this.getEntityStats();
        if (props.isPirate()) {
            this.setPirateDetails();
        } else if (props.isMarine()) {
            this.setMarineDetails();
        } else if (props.isBandit()) {
            this.setBanditDetails();
        }
        this.chooseTexture();
        if (props.isSniper()) {
            this.setSniperDetails();
        }
    }

    private void setSniperDetails() {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.SENRIKU.get()));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeRangedStyleSwitchGoal((MobEntity)this).forceMeleeEmptyHanded().addStyleSwitchEvent(100, this::onStyleSwitched));
        this.rangePhase.addGoal(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 60, 60.0f));
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new KaenBoshiWrapperGoal((MobEntity)this), 6.0f);
        goals.addEntry(() -> new TokuyoAburaBoshiWrapperGoal((MobEntity)this), 4.0f);
        goals.addEntry(() -> new KemuriBoshiWrapperGoal((MobEntity)this, 60), 4.0f);
        goals.addEntry(() -> new TetsuBoshiWrapperGoal((MobEntity)this, 60), 3.0f);
        goals.addEntry(() -> new SakuretsuSabotenBoshiWrapperGoal((MobEntity)this), 3.0f);
        MobsHelper.getRandomizedGoals((MobEntity)this, this.isAboveNormalDifficulty() ? 3 : 2, goals).forEach(goal -> this.rangePhase.addGoal(2, (Goal)goal));
    }

    private void setMarineDetails() {
        this.setTextures(MobsHelper.MARINE_TEXTURES);
    }

    private void setPirateDetails() {
        this.setTextures(MobsHelper.PIRATE_TEXTURES);
        if (this.field_70170_p.func_201674_k().nextInt(10) < 3) {
            this.getEntityStats().setRace(ModValues.FISHMAN);
            this.queueEntityDataUpdate();
            this.setTextures(MobsHelper.PIRATE_FISHMEN_TEXTURES);
        }
    }

    private void setBanditDetails() {
        this.setTextures(MobsHelper.BANDIT_TEXTURES);
    }

    @Override
    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        if (!this.getEntityStats().isMarine()) {
            return false;
        }
        IEntityStats senderProps = EntityStatsCapability.get(commandSender);
        if (!senderProps.isMarine()) {
            return false;
        }
        return senderProps.hasMarineRank(FactionHelper.MarineRank.ADMIRAL);
    }

    @Override
    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    @Override
    public boolean canMaintainCommand() {
        return this.lastCommandSender == null || !this.lastCommandSender.func_70089_S() || !EntityStatsCapability.get(this.lastCommandSender).isRogue();
    }

    @Override
    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    @Override
    public long getLastCommandTime() {
        return this.lastCommandTime;
    }

    public static boolean checkSpawnRules(EntityType<? extends OPEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        BlockPos worldSpawn;
        if (reason != SpawnReason.SPAWNER && pos.func_218141_a((Vector3i)(worldSpawn = new BlockPos(world.func_72912_H().func_76079_c(), world.func_72912_H().func_76075_d(), world.func_72912_H().func_76074_e())), 256.0)) {
            return false;
        }
        double chance = random.nextDouble() * 100.0;
        if (chance > CommonConfig.INSTANCE.getSniperSpawnChance()) {
            return false;
        }
        return OPEntity.checkSpawnRules(type, world, reason, pos, random);
    }
}

