/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.ability;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.IRandomTexture;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.ITamableEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.AbstractBanditEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FactionHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.AbstractMarineEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AbstractPirateEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.kage.KageProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModTags;

public class NightmareSoldierEntity
extends CreatureEntity
implements IRandomTexture,
ICommandReceiver,
IEntityAdditionalSpawnData,
ITamableEntity {
    private static final int RESPAWN_TIMER = 600;
    @Nullable
    private UUID ownerId;
    @Nullable
    private LivingEntity owner;
    private ResourceLocation currentTexture;
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;
    private boolean respawning;
    private int respawnTimer;
    private boolean canDieTick;

    public NightmareSoldierEntity(EntityType type, World world) {
        this(world);
    }

    public NightmareSoldierEntity(World world) {
        super((EntityType)KageProjectiles.NIGHTMARE_SOLDIER.get(), world);
        if (world != null && !world.field_72995_K) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            props.setHeart(false);
            props.setShadow(true);
            int id = this.field_70146_Z.nextInt(MobsHelper.NIGHTMARE_SOLDIER_TEXTURES.length);
            this.currentTexture = MobsHelper.NIGHTMARE_SOLDIER_TEXTURES[id];
        }
    }

    protected void func_184651_r() {
        CommandAbility.addCommandGoals((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AbstractMarineEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AbstractPirateEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AbstractBanditEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_(Attributes.field_233826_i_, 0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public boolean func_70097_a(DamageSource damageSource, float damageValue) {
        if (damageSource.func_76357_e()) {
            this.canDieTick = true;
            return super.func_70097_a(damageSource, damageValue);
        }
        if (damageSource.func_76364_f() != null) {
            if (ModTags.Entities.KAIROSEKI.func_230235_a_((Object)damageSource.func_76364_f().func_200600_R())) {
                this.canDieTick = true;
                this.func_70097_a(ModDamageSource.DEVILS_CURSE, this.func_110138_aP());
                return false;
            }
            if (this.respawning && damageSource.func_76364_f() instanceof PlayerEntity) {
                return false;
            }
        }
        if (damageSource.func_76346_g() != null) {
            if (damageSource instanceof AbilityDamageSource && ((AbilityDamageSource)damageSource).getElement() == SourceElement.WATER) {
                this.canDieTick = true;
                this.func_70097_a(ModDamageSource.DEVILS_CURSE, this.func_110138_aP());
                return false;
            }
            if (damageSource.func_76346_g() instanceof PlayerEntity && damageSource.func_76346_g() == this.getOwner()) {
                return false;
            }
        }
        return super.func_70097_a(damageSource, damageValue);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getOwner() == null || !this.getOwner().func_70089_S()) {
                this.func_70106_y();
                return;
            }
            if (this.canDieTick) {
                this.func_70097_a(ModDamageSource.DEVILS_CURSE, this.func_110138_aP());
            } else if (!this.canDieTick && this.func_110143_aJ() <= 0.0f) {
                this.func_70606_j(1.0f);
                this.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 600, 0));
                this.respawning = true;
                this.respawnTimer = 600;
            }
            if (this.respawning) {
                if (this.respawnTimer > 0) {
                    --this.respawnTimer;
                } else {
                    this.func_195063_d((Effect)ModEffects.UNCONSCIOUS.get());
                    this.func_70606_j(this.func_110138_aP());
                    this.respawning = false;
                }
            }
            if (this.func_70089_S() && (this.func_233571_b_((ITag)FluidTags.field_206959_a) > 0.9 || this.func_70644_a((Effect)ModEffects.WET.get()))) {
                this.func_70097_a(ModDamageSource.DEVILS_CURSE, this.func_110138_aP());
            }
        }
        super.func_70071_h_();
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.ownerId != null) {
            nbt.func_186854_a("ownerId", this.ownerId);
        }
        if (this.currentTexture != null) {
            nbt.func_74778_a("texture", this.currentTexture.toString());
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("ownerId")) {
            this.ownerId = nbt.func_186857_a("ownerId");
        }
        if (nbt.func_74764_b("texture")) {
            this.currentTexture = new ResourceLocation(nbt.func_74779_i("texture"));
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179252_a(this.ownerId);
        int len = this.currentTexture.toString().length();
        buffer.writeInt(len);
        buffer.func_211400_a(this.currentTexture.toString(), len);
    }

    public void readSpawnData(PacketBuffer data) {
        this.ownerId = data.func_179253_g();
        int len = data.readInt();
        this.currentTexture = new ResourceLocation(data.func_150789_c(len));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
        this.ownerId = owner.func_110124_au();
        IEntityStats stats = EntityStatsCapability.get((LivingEntity)this);
        stats.setFaction(EntityStatsCapability.get(owner).getFaction());
        Predicate<Entity> factionScope = ModEntityPredicates.getEnemyFactions((LivingEntity)this);
        Predicate<Entity> notSame = entity -> !(entity instanceof NightmareSoldierEntity);
        if (factionScope != null) {
            this.field_70715_bh.func_75776_a(1, (Goal)new FactionHurtByTargetGoal(this, factionScope, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, true, factionScope.and(notSame)));
        }
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        if (this.owner == null && this.ownerId != null) {
            this.owner = this.field_70170_p.func_217371_b(this.ownerId);
        }
        return this.owner;
    }

    @Override
    public ResourceLocation getCurrentTexture() {
        return this.currentTexture;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return MobsHelper.NIGHTMARE_SOLDIER_TEXTURES[0];
    }

    @Override
    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        if (this.getOwner() == null || commandSender == null) {
            return false;
        }
        return this.getOwner().equals((Object)commandSender);
    }

    @Override
    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    @Override
    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    @Override
    public long getLastCommandTime() {
        return this.lastCommandTime;
    }
}

