/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.FishSwimMoveController;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.LandFishLookController;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.AvoidBlockTagGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.AvoidCoatedBoatGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.EatNearbyFishGoal;
import xyz.pixelatedw.mineminenomi.init.ModTags;

public class FlyingFishEntity
extends TameableEntity {
    private static final DataParameter<Boolean> IS_SADDLED = EntityDataManager.func_187226_a(FlyingFishEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String SADDLED_TAG = "isSaddled";
    private static final double TAME_CHANCE = 0.25;
    private static final Item[] SADDLES = new Item[]{Items.field_151141_av};
    private static final Food[] FOODS = new Food[]{Foods.field_221434_j, Foods.field_221420_H, Foods.field_221424_L, Foods.field_221437_m, Foods.field_221441_q, Foods.field_221415_C};

    public FlyingFishEntity(EntityType type, World world) {
        super(type, world);
        this.field_70765_h = new FishSwimMoveController<FlyingFishEntity>(this);
        this.field_70749_g = new LandFishLookController<FlyingFishEntity>(this, 10);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_70661_as().func_212239_d(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidBlockTagGoal((CreatureEntity)this, (ITag.INamedTag<Block>)ModTags.Blocks.KAIROSEKI));
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidCoatedBoatGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new EatNearbyFishGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 12.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_SADDLED, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)1.3f).func_233815_a_(Attributes.field_233819_b_, 55.0).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public double func_70042_X() {
        return super.func_70042_X();
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double y = this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W();
            Vector3d posVec = new Vector3d(0.4, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + posVec.field_72450_a, y, this.func_226281_cx_() + posVec.field_72449_c);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            ItemStack stack = player.func_184586_b(player.func_184600_cs() != null ? player.func_184600_cs() : Hand.MAIN_HAND);
            boolean isSaddle = Arrays.stream(SADDLES).anyMatch(stack.func_77973_b()::equals);
            if (!this.func_70909_n()) {
                if (!stack.func_190926_b() && this.func_70877_b(stack)) {
                    this.func_175505_a(player, stack);
                    double chance = this.field_70146_Z.nextDouble();
                    if (chance < 0.25 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        this.func_193101_c(player);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (this.func_70877_b(stack) && this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(4.0f);
                    this.func_175505_a(player, stack);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    return ActionResultType.SUCCESS;
                }
                if (isSaddle && !this.isSaddled() && !this.func_70631_g_()) {
                    this.setSaddled(true);
                    this.field_70170_p.func_217384_a((PlayerEntity)null, (Entity)this, SoundEvents.field_187726_cu, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    this.func_175505_a(player, stack);
                    return ActionResultType.SUCCESS;
                }
                if (this.isSaddled() && (!this.func_70877_b(stack) || this.func_70877_b(stack) && !this.func_204701_dC()) && player == this.func_70902_q() && !this.func_70631_g_()) {
                    player.func_184220_m((Entity)this);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return super.func_230254_b_(player, hand);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70877_b(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Food food = stack.func_77973_b().func_219967_s();
        if (food == null) return false;
        if (!Arrays.stream(FOODS).anyMatch(food::equals)) return false;
        return true;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity controller = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = controller.field_70177_z;
                this.field_70125_A = controller.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                if (this.func_184186_bw()) {
                    boolean isMoving;
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * 0.7f);
                    boolean bl = isMoving = !(controller.field_191988_bg > 0.0f);
                    if (!isMoving) {
                        float speed = 0.5f;
                        Vector3d vec = controller.func_70040_Z();
                        double x = vec.field_72450_a * (double)speed;
                        double y = vec.field_72448_b * (double)speed;
                        double z = vec.field_72449_c * (double)speed;
                        AbilityHelper.setDeltaMovement((Entity)this, x, y, z);
                    } else {
                        double y = 0.0;
                        if (!this.func_204231_K()) {
                            y = this.func_213322_ci().field_72448_b * 0.99;
                            y = Math.max(y, -1.0);
                        }
                        AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().field_72450_a, y, this.func_213322_ci().field_72449_c);
                    }
                    super.func_213352_e(this.func_213322_ci());
                } else if (controller instanceof PlayerEntity) {
                    AbilityHelper.setDeltaMovement((Entity)this, Vector3d.field_186680_a);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                super.func_213352_e(travelVector);
            }
        }
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_205019_a(IWorldReader pLevel) {
        return pLevel.func_226668_i_((Entity)this);
    }

    protected void handleAirSupply(int airSupply) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.func_70050_g(airSupply - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        this.handleAirSupply(i);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity pPlayer) {
        return true;
    }

    public boolean func_213397_c(double distance) {
        return !this.func_70909_n() && distance > 1024.0;
    }

    protected PathNavigator func_175447_b(World level) {
        return new SwimmerPathNavigator((MobEntity)this, level);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a(SADDLED_TAG, ((Boolean)this.field_70180_af.func_187225_a(IS_SADDLED)).booleanValue());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)nbt.func_74767_n(SADDLED_TAG));
    }

    public void setSaddled(boolean flag) {
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)flag);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SADDLED);
    }

    public AgeableEntity func_241840_a(ServerWorld pServerLevel, AgeableEntity pMate) {
        return null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static boolean checkSpawnRules(EntityType<FlyingFishEntity> entity, IWorld world, SpawnReason spawnType, BlockPos pos, Random random) {
        return world.func_180495_p(pos.func_177977_b()).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }
}

