/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.entity.PartEntity;
import xyz.pixelatedw.mineminenomi.abilities.TailSpinAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.TackleAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhaseManager;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.FishSwimMoveController;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.LandFishLookController;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.PandaSharkEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.YagaraBullEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.AvoidBlockTagGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.AvoidCoatedBoatGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.EatNearbyFishGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.StunStacksGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.BellyFlopWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.TailSpinWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.TackleWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModTags;

public class SeaCowEntity
extends TameableEntity {
    private static final UUID TAIL_SPIN_RANGE_BONUS = UUID.fromString("3da76e8f-b539-4a87-b764-8edab430cd77");
    private static final AttributeModifier SWIM_SPEED_MOD = new AttributeModifier(UUID.fromString("7da9447a-362c-4c83-bdde-32e07a939b7e"), "Swim Speed Bonus", 1.0, AttributeModifier.Operation.ADDITION);
    private TargetsPredicate tailSpinAOECheck;
    private float size;
    private static final float MIN_SIZE = 2.0f;
    private static final float MAX_SIZE = 3.5f;
    private final SeaCowPartEntity head;
    private final SeaCowPartEntity tail;
    private final SeaCowPartEntity[] subEntities;
    private MovementController groundMovementController;
    private MovementController waterMovementController;
    private LookController groundLookControl;
    private LookController waterLookControl;
    private PathNavigator groundNavigator;
    private PathNavigator waterNavigator;
    private final NPCPhaseManager phaseManager = new NPCPhaseManager((MobEntity)this);
    private NPCPhase<SeaCowEntity> groundPhase;
    private NPCPhase<SeaCowEntity> waterPhase;
    private StunStacksGoal stunStackGoal;
    private TackleWrapperGoal tackleWrapper;

    public SeaCowEntity(EntityType type, World world) {
        super(type, world);
        this.head = new SeaCowPartEntity(this, "head", 2.5f, 2.5f);
        this.tail = new SeaCowPartEntity(this, "tail", 3.0f, 3.0f);
        this.subEntities = new SeaCowPartEntity[]{this.head, this.tail};
        this.tailSpinAOECheck = TargetsPredicate.DEFAULT_AREA_CHECK.selector(entity -> {
            if (this.func_70638_az() != null && this.func_70638_az() == entity) {
                return true;
            }
            return !(entity instanceof YagaraBullEntity) && !(entity instanceof SeaCowEntity) && !(entity instanceof PandaSharkEntity) && !(entity instanceof DolphinEntity);
        });
        this.groundMovementController = new MovementController((MobEntity)this);
        this.waterMovementController = new FishSwimMoveController<SeaCowEntity>(this);
        this.groundLookControl = new LookController((MobEntity)this);
        this.waterLookControl = new LandFishLookController<SeaCowEntity>(this, 10);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, world);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, world);
        this.func_145769_d(field_213331_b.getAndAdd(this.subEntities.length + 1) + 1);
        if (world != null && !world.field_72995_K) {
            this.groundPhase = new SimplePhase<SeaCowEntity>("Ground Phase", this, this::startGroundPhaseEvent);
            this.waterPhase = new SimplePhase<SeaCowEntity>("Water Phase", this, this::startWaterPhaseEvent);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
            this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(4.0);
            this.stunStackGoal = new StunStacksGoal((MobEntity)this, 3, 10);
            TailSpinWrapperGoal tailSpinWrapper = new TailSpinWrapperGoal((MobEntity)this);
            ((TailSpinAbility)tailSpinWrapper.getAbility()).getComponent(ModAbilityKeys.RANGE).ifPresent(comp -> {
                comp.setAreaCheck(this.tailSpinAOECheck);
                comp.getBonusManager().addBonus(TAIL_SPIN_RANGE_BONUS, "Tail Spin Range Bonus", BonusOperation.MUL, 4.0f);
            });
            this.tackleWrapper = new TackleWrapperGoal((MobEntity)this);
            this.field_70714_bg.func_75776_a(0, (Goal)this.stunStackGoal);
            this.field_70714_bg.func_75776_a(0, (Goal)new AvoidBlockTagGoal((CreatureEntity)this, (ITag.INamedTag<Block>)ModTags.Blocks.KAIROSEKI));
            this.field_70714_bg.func_75776_a(0, (Goal)new AvoidCoatedBoatGoal((CreatureEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.25, true));
            this.field_70714_bg.func_75776_a(0, (Goal)new EatNearbyFishGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(2, (Goal)tailSpinWrapper);
            this.field_70714_bg.func_75776_a(2, (Goal)this.tackleWrapper);
            this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.groundPhase.addGoal(2, new BellyFlopWrapperGoal((MobEntity)this));
            this.groundPhase.addGoal(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.8));
            this.waterPhase.addGoal(0, (Goal)new FindWaterGoal((CreatureEntity)this));
            this.waterPhase.addGoal(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.phaseManager.setPhase(this.groundPhase);
        }
    }

    public void func_145769_d(int pId) {
        super.func_145769_d(pId);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].func_145769_d(pId + i + 1);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233820_c_, (double)0.7f).func_233815_a_(Attributes.field_233821_d_, (double)0.27f).func_233815_a_(Attributes.field_233819_b_, 70.0).func_233815_a_(Attributes.field_233818_a_, 100.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        Vector3d[] avector3d = new Vector3d[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avector3d[j] = new Vector3d(this.subEntities[j].func_226277_ct_(), this.subEntities[j].func_226278_cu_(), this.subEntities[j].func_226281_cx_());
        }
        float headRot = MathHelper.func_219799_g((float)1.0f, (float)this.field_70759_as, (float)this.field_70761_aq);
        float rot = headRot * ((float)Math.PI / 180);
        float x = MathHelper.func_76126_a((float)rot);
        float z = MathHelper.func_76134_b((float)rot);
        this.tickPart(this.head, -x * 3.5f, 1.5, z * 3.5f);
        this.tickPart(this.tail, x * 4.0f, -0.25, -z * 4.0f);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].field_70169_q = avector3d[l].field_72450_a;
            this.subEntities[l].field_70167_r = avector3d[l].field_72448_b;
            this.subEntities[l].field_70166_s = avector3d[l].field_72449_c;
            this.subEntities[l].field_70142_S = avector3d[l].field_72450_a;
            this.subEntities[l].field_70137_T = avector3d[l].field_72448_b;
            this.subEntities[l].field_70136_U = avector3d[l].field_72449_c;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_70090_H()) {
                this.phaseManager.setPhase(this.waterPhase);
            } else {
                this.phaseManager.setPhase(this.groundPhase);
            }
        }
    }

    public void func_70619_bc() {
        this.phaseManager.tick();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_187562_am;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.5f;
    }

    protected PathNavigator func_175447_b(World level) {
        return new SwimmerPathNavigator((MobEntity)this, level);
    }

    public void func_213352_e(Vector3d moveVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), moveVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(moveVector);
        }
    }

    public int func_70646_bf() {
        if (this.phaseManager.getCurrentPhase() != null && this.phaseManager.getCurrentPhase().equals(this.waterPhase)) {
            return 1;
        }
        return super.func_70646_bf();
    }

    public int func_184649_cE() {
        if (this.phaseManager.getCurrentPhase() != null && this.phaseManager.getCurrentPhase().equals(this.waterPhase)) {
            return 1;
        }
        return super.func_184649_cE();
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public boolean hurt(SeaCowPartEntity part, DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && part.equals((Object)this.head) && ((TackleAbility)this.tackleWrapper.getAbility()).isContinuous()) {
            amount *= 1.5f;
            ((TackleAbility)this.tackleWrapper.getAbility()).getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.stopContinuity((LivingEntity)this));
            this.stunStackGoal.addStack(5);
        }
        return this.func_70097_a(source, amount);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.size = Math.min(2.0f + this.field_70146_Z.nextFloat(), 3.5f);
    }

    public EntitySize func_213305_a(Pose pose) {
        float scale = this.getSize() * (this.func_70874_b() < 0 ? 0.5f : 1.0f);
        EntitySize newSize = this.func_200600_R().func_220334_j().func_220313_a(scale);
        return newSize;
    }

    private void tickPart(SeaCowPartEntity part, double offsetX, double offsetY, double offsetZ) {
        part.func_70107_b(this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("size", this.size);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.size = compound.func_74760_g("size");
    }

    public float getSize() {
        return this.size;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        SeaCowEntity offspring = (SeaCowEntity)((EntityType)ModEntities.SEA_COW.get()).func_200721_a((World)world);
        return offspring;
    }

    private void startWaterPhaseEvent(SeaCowEntity entity) {
        this.field_70765_h = this.waterMovementController;
        this.field_70749_g = this.waterLookControl;
        this.field_70699_by.func_75499_g();
        this.field_70699_by = this.waterNavigator;
        ModifiableAttributeInstance attr = this.func_110148_a(Attributes.field_233821_d_);
        if (attr != null && !attr.func_180374_a(SWIM_SPEED_MOD)) {
            attr.func_233767_b_(SWIM_SPEED_MOD);
        }
    }

    private void startGroundPhaseEvent(SeaCowEntity entity) {
        this.field_70765_h = this.groundMovementController;
        this.field_70749_g = this.groundLookControl;
        this.field_70699_by.func_75499_g();
        this.field_70699_by = this.groundNavigator;
        ModifiableAttributeInstance attr = this.func_110148_a(Attributes.field_233821_d_);
        if (attr != null) {
            attr.func_111124_b(SWIM_SPEED_MOD);
        }
    }

    private class SeaCowPartEntity
    extends PartEntity<SeaCowEntity> {
        public final SeaCowEntity parentMob;
        public final String name;
        private final EntitySize size;

        public SeaCowPartEntity(SeaCowEntity parent, String name, float width, float height) {
            super((Entity)parent);
            this.size = EntitySize.func_220314_b((float)width, (float)height);
            this.func_213323_x_();
            this.parentMob = parent;
            this.name = name;
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(CompoundNBT pCompound) {
        }

        protected void func_213281_b(CompoundNBT pCompound) {
        }

        public boolean func_70067_L() {
            return true;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            return this.func_180431_b(source) ? false : this.parentMob.hurt(this, source, amount);
        }

        public boolean func_70028_i(Entity entity) {
            return this == entity || this.parentMob == entity;
        }

        public EntitySize func_213305_a(Pose pPose) {
            return this.size;
        }
    }
}

