/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AvoidBlockGoal
extends Goal {
    private CreatureEntity entity;
    private Vector3d toAvoid;
    private final Set<Block> blocksToAvoid;
    private Set<BlockPos> cachedPositions = new HashSet<BlockPos>();
    private int radius = 15;
    private long lastCheck;
    private Path path;
    private final PathNavigator pathNav;
    private double speed = 2.0;
    private double sprintSpeed = 4.0;

    public AvoidBlockGoal(CreatureEntity entity, Set<Block> toAvoid) {
        this.entity = entity;
        this.blocksToAvoid = toAvoid;
        this.pathNav = entity.func_70661_as();
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public void setSprintSpeed(double speed) {
        this.sprintSpeed = speed;
    }

    public boolean func_75250_a() {
        if (this.entity == null || !this.entity.func_70089_S()) {
            return false;
        }
        if (this.entity.func_70638_az() == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastCheck < 1000L) {
            return false;
        }
        if (this.cachedPositions.size() > 0) {
            for (BlockPos pos : this.cachedPositions) {
                boolean isSameBlock = this.blocksToAvoid.contains(this.entity.field_70170_p.func_180495_p(pos).func_177230_c());
                if (isSameBlock && this.entity.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < (double)(this.radius * this.radius)) {
                    this.toAvoid = RandomPositionGenerator.func_75461_b((CreatureEntity)this.entity, (int)128, (int)64, (Vector3d)new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
                    if (this.toAvoid == null) {
                        return false;
                    }
                    this.path = this.pathNav.func_225466_a(this.toAvoid.field_72450_a, this.toAvoid.field_72448_b, this.toAvoid.field_72449_c, 0);
                    return this.path != null;
                }
                if (isSameBlock) continue;
                this.cachedPositions.remove(pos);
            }
            return false;
        }
        List<BlockPos> blocks = WyHelper.getNearbyBlocks(this.entity.func_233580_cy_(), (IWorld)this.entity.field_70170_p, this.radius, this.radius, this.radius, b -> this.blocksToAvoid.contains(b.func_177230_c()));
        this.lastCheck = System.currentTimeMillis();
        this.cachedPositions.clear();
        this.cachedPositions.addAll(blocks);
        return false;
    }

    public boolean func_75253_b() {
        return !this.pathNav.func_75500_f();
    }

    public void func_75249_e() {
        this.pathNav.func_75484_a(this.path, this.speed);
    }

    public void func_75251_c() {
        this.toAvoid = null;
    }

    public void func_75246_d() {
        if (this.entity.func_195048_a(this.toAvoid) < 49.0) {
            this.entity.func_70661_as().func_75489_a(this.sprintSpeed);
        } else {
            this.entity.func_70661_as().func_75489_a(this.speed);
        }
        this.pathNav.func_75484_a(this.path, this.speed);
    }
}

