/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class JumpOutOfHoleGoal
extends TickedGoal<MobEntity> {
    private static final int COOLDOWN = 60;
    private LivingEntity target;
    private boolean pushed;
    private final float jumpHeight;

    public JumpOutOfHoleGoal(MobEntity entity) {
        this(entity, 1.3f);
    }

    public JumpOutOfHoleGoal(MobEntity entity, float jumpHeight) {
        super(entity);
        this.jumpHeight = jumpHeight;
    }

    public boolean func_75250_a() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!this.hasTimePassedSinceLastEnd(60.0f)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (GoalUtil.hasSolidBlockAbove((LivingEntity)this.entity)) {
            return false;
        }
        return GoalUtil.hasBlockInFace((LivingEntity)this.entity);
    }

    public boolean func_75253_b() {
        if (this.hasTimePassedSinceStart(100.0f)) {
            return false;
        }
        return !this.pushed;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.pushed = false;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (!this.pushed) {
            if (this.getTickCount() % 40L == 0L) {
                AbilityHelper.setDeltaMovement((Entity)this.entity, 0.0, this.jumpHeight, 0.0);
            }
            if (GoalUtil.canSee(this.entity, this.target) && !GoalUtil.hasBlockInFace((LivingEntity)this.entity)) {
                GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
                Vector3d push = this.target.func_213303_ch().func_178788_d(this.entity.func_213303_ch()).func_72432_b().func_216372_d(2.0, 0.0, 2.0);
                AbilityHelper.setDeltaMovement((Entity)this.entity, push.field_72450_a, this.entity.func_213322_ci().func_82617_b() + 0.2, push.field_72449_c);
                this.pushed = true;
            }
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
    }
}

