/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;

public class PersonalSpaceTargetGoal
extends TickedGoal<MobEntity> {
    private static final int TICKS_BEFORE_MARK_UPDATE = 200;
    private HashMap<Integer, Long> personalSpaceTargets = new HashMap();
    private Interval checkInterval = new Interval(20);
    private final int ticksBeforeAttacking;
    private final double checkDistance;
    private final Predicate<LivingEntity> targetCheck;

    public PersonalSpaceTargetGoal(MobEntity entity) {
        this(entity, 10.0, 200);
    }

    public PersonalSpaceTargetGoal(MobEntity entity, double checkDistance) {
        this(entity, checkDistance, 200);
    }

    public PersonalSpaceTargetGoal(MobEntity entity, double checkDistance, int ticksBeforeAttacking) {
        super(entity);
        this.checkDistance = checkDistance;
        this.ticksBeforeAttacking = ticksBeforeAttacking;
        this.targetCheck = this.getDefaultTargetCheck((LivingEntity)entity);
    }

    public PersonalSpaceTargetGoal(MobEntity entity, double checkDistance, int ticksBeforeAttacking, Predicate<LivingEntity> targetCheck) {
        super(entity);
        this.checkDistance = checkDistance;
        this.ticksBeforeAttacking = ticksBeforeAttacking;
        this.targetCheck = targetCheck;
    }

    public boolean func_75250_a() {
        if (!this.entity.func_70089_S()) {
            return false;
        }
        if (GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        return this.hasTimePassedSinceLastEnd(60.0f);
    }

    public boolean func_75253_b() {
        if (!this.entity.func_70089_S()) {
            return false;
        }
        if (GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        return GoalUtil.getNearbyVisibleEntities((LivingEntity)this.entity, this.checkDistance, null).size() > 0;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.checkInterval.restartIntervalToMax();
        this.personalSpaceTargets.clear();
    }

    @Override
    public void func_75246_d() {
        List<LivingEntity> targets;
        super.func_75246_d();
        if (this.checkInterval.canTick() && (targets = TargetHelper.getEntitiesInArea((LivingEntity)this.entity, this.checkDistance, null, LivingEntity.class)).size() > 0) {
            for (LivingEntity target : targets) {
                if (!this.targetCheck.test(target)) continue;
                if (this.personalSpaceTargets.containsKey(target.func_145782_y())) {
                    long time = this.personalSpaceTargets.get(target.func_145782_y());
                    if (this.entity.field_70170_p.func_82737_E() < time + (long)this.ticksBeforeAttacking) continue;
                    this.entity.func_70624_b(target);
                    continue;
                }
                this.personalSpaceTargets.put(target.func_145782_y(), this.entity.field_70170_p.func_82737_E());
            }
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
    }

    public Predicate<LivingEntity> getDefaultTargetCheck(LivingEntity entity) {
        return target -> {
            if (target instanceof PlayerEntity) {
                return true;
            }
            return !target.func_200600_R().equals(entity.func_200600_R());
        };
    }
}

