/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.api.animations.IAnimation;
import xyz.pixelatedw.mineminenomi.api.entities.ai.IAnimatedGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class GuardGoal
extends CooldownGoal
implements IAnimatedGoal {
    private int duration;
    private int maxDuration = 40;
    private int maxCount;
    private int hitCount;
    private float prevHealth;

    public GuardGoal(OPEntity entity) {
        super(entity);
        this.setMaxCooldown(7.0);
    }

    public <T extends GuardGoal> T setHitCounter(int maxCount) {
        this.maxCount = maxCount;
        return (T)this;
    }

    public <T extends GuardGoal> T setDuration(int duration) {
        this.maxDuration = duration;
        return (T)this;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        LivingEntity target = this.entity.func_70638_az();
        if (target == null) {
            return false;
        }
        float distance = this.entity.func_70032_d((Entity)target);
        if (distance > 3.0f) {
            return false;
        }
        if (this.prevHealth == 0.0f) {
            this.prevHealth = this.entity.func_110143_aJ();
        }
        if (this.entity.func_110143_aJ() < this.prevHealth) {
            ++this.hitCount;
            this.prevHealth = this.entity.func_110143_aJ();
        }
        return this.maxCount <= 0 || this.hitCount >= this.maxCount;
    }

    @Override
    public boolean func_75253_b() {
        boolean isGoing = true;
        if (this.maxDuration > 0) {
            isGoing = this.duration < this.maxDuration;
        }
        return isGoing && !this.isOnCooldown();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.startAnimation(this.entity);
        this.hitCount = 0;
        this.duration = 0;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        ++this.duration;
        LivingEntity target = this.entity.func_70638_az();
        if (target == null) {
            this.setOnCooldown(true);
            return;
        }
        if (this.prevHealth == 0.0f) {
            this.prevHealth = this.entity.func_110143_aJ();
        }
        if (this.entity.func_110143_aJ() < this.prevHealth) {
            ++this.hitCount;
            this.prevHealth = this.entity.func_110143_aJ();
        }
        this.entity.func_200602_a(EntityAnchorArgument.Type.EYES, target.func_213303_ch());
        this.entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 10, 0));
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.stopAnimation(this.entity);
    }

    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public IAnimation getAnimation() {
        return null;
    }

    @Override
    public boolean isAnimationActive(LivingEntity entity) {
        return this.func_75253_b();
    }
}

