/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.TekkaiAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;

public class TekkaiWrapperGoal
extends AbilityWrapperGoal<MobEntity, TekkaiAbility> {
    private LivingEntity target;
    private double distance = 10.0;
    private int lastHurtTicks = 60;
    private int hits = 0;
    private long lastHitTimestamp;

    public TekkaiWrapperGoal(MobEntity entity) {
        super(entity, TekkaiAbility.INSTANCE);
    }

    public TekkaiWrapperGoal setMinDistance(double distance) {
        this.distance = distance;
        return this;
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.distance)) {
            return false;
        }
        if (this.hits < 3) {
            if (this.lastHitTimestamp == 0L) {
                this.lastHitTimestamp = this.entity.field_70170_p.func_82737_E();
            }
            if (GoalUtil.lastHurtCheckBefore((LivingEntity)this.entity, this.lastHurtTicks) && this.entity.field_70170_p.func_82737_E() > this.lastHitTimestamp + (long)this.lastHurtTicks) {
                ++this.hits;
                this.lastHitTimestamp = this.entity.field_70170_p.func_82737_E();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canContinueToUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.distance * 1.5)) {
            return false;
        }
        return !GoalUtil.lastHurtCheckAfter((LivingEntity)this.entity, (int)((double)this.lastHurtTicks / 1.5));
    }

    @Override
    public void startWrapper() {
        FluidState fluidState = this.entity.field_70170_p.func_204610_c(this.entity.func_233580_cy_());
        if (!fluidState.func_206888_e()) {
            ((TekkaiAbility)this.getAbility()).switchToWalkMode((LivingEntity)this.entity);
        } else {
            ((TekkaiAbility)this.getAbility()).switchToHeavyMode((LivingEntity)this.entity);
        }
        this.hits = 0;
    }

    @Override
    public void tickWrapper() {
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void stopWrapper() {
        this.hits = 0;
    }
}

