/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sube;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import xyz.pixelatedw.mineminenomi.abilities.sube.SubeSubeDeflectAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;

public class SubeSubeDeflectWrapperGoal
extends AbilityWrapperGoal<MobEntity, SubeSubeDeflectAbility> {
    private LivingEntity target;
    private double distance = 10.0;
    private int lastHurtTicks = 60;
    private int hits = 0;
    private long lastHitTimestamp;

    public SubeSubeDeflectWrapperGoal(MobEntity entity) {
        super(entity, SubeSubeDeflectAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.distance)) {
            return false;
        }
        if (this.hits < 2) {
            if (this.lastHitTimestamp == 0L) {
                this.lastHitTimestamp = this.entity.field_70170_p.func_82737_E();
            }
            if (GoalUtil.lastHurtCheckBefore((LivingEntity)this.entity, this.lastHurtTicks) && this.entity.field_70170_p.func_82737_E() > this.lastHitTimestamp + (long)this.lastHurtTicks) {
                ++this.hits;
                this.lastHitTimestamp = this.entity.field_70170_p.func_82737_E();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canContinueToUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.distance * 1.5)) {
            return false;
        }
        return !GoalUtil.lastHurtCheckAfter((LivingEntity)this.entity, (int)((double)this.lastHurtTicks / 1.5));
    }

    @Override
    public void startWrapper() {
        this.hits = 0;
    }

    @Override
    public void tickWrapper() {
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void stopWrapper() {
        this.hits = 0;
    }
}

