/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.donkrieg;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.BruteEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.GruntEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.DonKriegEntity;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MH5PhaseGoal
extends TickedGoal<DonKriegEntity> {
    private BlockPos[] spawnPositions = new BlockPos[4];
    private int findIter = 0;
    private int spawnIter = 0;
    private final ExtendedWorldData worldData = ExtendedWorldData.get();
    private final int spawnIterMax;
    private final int spawnRate;

    public MH5PhaseGoal(DonKriegEntity entity) {
        super(entity);
        this.spawnRate = entity.isDifficultyHardOrAbove() ? 40 : 60;
        this.spawnIterMax = entity.isDifficultyHardOrAbove() ? 7 : 5;
    }

    public boolean func_75250_a() {
        if (this.hasSpawnArrayEmptyPos() && this.findIter < 100) {
            this.findSpawnPos();
            return false;
        }
        return ((DonKriegEntity)this.entity).hasMH5PhaseActive();
    }

    public boolean func_75253_b() {
        if (!((DonKriegEntity)this.entity).hasMH5PhaseActive()) {
            return false;
        }
        return this.spawnIter < this.spawnIterMax;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (((DonKriegEntity)this.entity).field_70170_p.field_72995_K) {
            return;
        }
        if (this.getTickCount() % (long)this.spawnRate == 0L) {
            for (BlockPos pos : this.spawnPositions) {
                OPEntity spawnEntity;
                boolean isBrute;
                if (pos == null) continue;
                boolean bl = isBrute = ((DonKriegEntity)this.entity).isDifficultyHardOrAbove() && ((DonKriegEntity)this.entity).func_70681_au().nextInt(3) == 0;
                if (isBrute) {
                    spawnEntity = BruteEntity.createPirateBrute((EntityType)ModEntities.PIRATE_GRUNT.get(), ((DonKriegEntity)this.entity).field_70170_p);
                    spawnEntity.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    this.worldData.addTemporaryCrewMember(ModNPCGroups.KRIEG_PIRATES, (LivingEntity)spawnEntity);
                } else {
                    spawnEntity = GruntEntity.createPirateGrunt((EntityType)ModEntities.PIRATE_GRUNT.get(), ((DonKriegEntity)this.entity).field_70170_p);
                    spawnEntity.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    this.worldData.addTemporaryCrewMember(ModNPCGroups.KRIEG_PIRATES, (LivingEntity)spawnEntity);
                }
                if (((DonKriegEntity)this.entity).getChallengeInfo().getChallengerGroup().size() > 1) {
                    List<LivingEntity> targets = WyHelper.shuffle(((DonKriegEntity)this.entity).getChallengeInfo().getChallengerGroup());
                    spawnEntity.func_70624_b(targets.get(0));
                } else {
                    spawnEntity.func_70624_b(((DonKriegEntity)this.entity).func_70638_az());
                }
                ((DonKriegEntity)this.entity).field_70170_p.func_217376_c((Entity)spawnEntity);
                if (((DonKriegEntity)this.entity).func_70681_au().nextInt(3) != 0) continue;
                spawnEntity.func_184201_a(EquipmentSlotType.HEAD, ((Item)ModArmors.MH5_GAS_MASK.get()).func_190903_i());
            }
            ++this.spawnIter;
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.cleanSpawnArray();
        this.findIter = 0;
    }

    private void findSpawnPos() {
        BlockPos pos = WyHelper.findValidGroundLocation(((DonKriegEntity)this.entity).field_70170_p, ((DonKriegEntity)this.entity).func_233580_cy_(), 20, 10);
        if (pos != null) {
            for (int i = 0; i < this.spawnPositions.length; ++i) {
                if (this.spawnPositions[i] != null) continue;
                this.spawnPositions[i] = pos;
                break;
            }
        } else {
            ++this.findIter;
        }
    }

    private boolean hasSpawnArrayEmptyPos() {
        boolean flag = false;
        for (BlockPos pos : this.spawnPositions) {
            if (pos != null) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void cleanSpawnArray() {
        for (int i = 0; i < this.spawnPositions.length; ++i) {
            this.spawnPositions[i] = null;
        }
    }
}

