/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.marines;

import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.ChargedCleaveAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.TackleAbility;
import xyz.pixelatedw.mineminenomi.abilities.morgan.MorganShockwaveAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.ShiganAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.TekkaiAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.OTatsumakiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ClimbOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.ChargedCleaveWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.SlamWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.TackleWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.RankyakuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.ShiganWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.SoruWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.OTatsumakiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.morgan.MorganMusterGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.morgan.MorganShockwaveWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModValues;

public class MorganEntity
extends OPBossEntity<MorganEntity> {
    private static final UUID HARD_TATSUMAKI_COOLDOWN_BONUS_UUID = UUID.fromString("4bd574cc-c5a2-4e73-8230-763ccf4544d5");
    private boolean usedMuster;

    public MorganEntity(EntityType type, World world) {
        super(type, world);
    }

    public MorganEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.MORGAN.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.entityStats.setFaction(ModValues.MARINE);
        this.entityStats.setRace(ModValues.HUMAN);
        this.entityStats.setFightingStyle(ModValues.BRAWLER);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(2.5);
        MobsHelper.addBasicNPCGoals(this);
        ChargedCleaveWrapperGoal chargedCleaveWrapper = new ChargedCleaveWrapperGoal((MobEntity)this).setBleedingTime(40);
        ((ChargedCleaveAbility)chargedCleaveWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            TackleAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(TackleAbility.INSTANCE);
            if (abl != null && abl.isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        MorganShockwaveWrapperGoal shockwaveWrapper = new MorganShockwaveWrapperGoal((MobEntity)this);
        TackleWrapperGoal tackleWrapper = new TackleWrapperGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new ClimbOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)tackleWrapper);
        this.field_70714_bg.func_75776_a(3, (Goal)chargedCleaveWrapper);
        this.field_70714_bg.func_75776_a(3, (Goal)shockwaveWrapper);
        this.field_70714_bg.func_75776_a(3, (Goal)new SlamWrapperGoal((MobEntity)this));
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(500.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(3.0);
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(6.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(6.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(4.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(10.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(250.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(12.0);
            ((MorganShockwaveAbility)shockwaveWrapper.getAbility()).setHardForm();
            OTatsumakiWrapperGoal tatsumakiWrapper = new OTatsumakiWrapperGoal((MobEntity)this);
            ((OTatsumakiAbility)tatsumakiWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_TATSUMAKI_COOLDOWN_BONUS_UUID, "Tatsumaki Cooldown Bonus", BonusOperation.ADD, -80.0f));
            ((ChargedCleaveAbility)chargedCleaveWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
                TekkaiAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(TekkaiAbility.INSTANCE);
                if (abl != null && abl.isContinuous()) {
                    return AbilityUseResult.fail(null);
                }
                return AbilityUseResult.success();
            });
            ShiganWrapperGoal shiganWrapper = new ShiganWrapperGoal((MobEntity)this);
            ((ShiganAbility)shiganWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
                ChargedCleaveAbility abl = AbilityDataCapability.get(entity).getEquippedAbility(ChargedCleaveAbility.INSTANCE);
                if (abl != null && abl.isCharging()) {
                    return AbilityUseResult.fail(null);
                }
                return AbilityUseResult.success();
            });
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new MorganMusterGoal(this));
            this.field_70714_bg.func_75776_a(2, (Goal)shiganWrapper);
            this.field_70714_bg.func_75776_a(2, (Goal)new SoruWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new RankyakuWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)tatsumakiWrapper);
            this.field_70714_bg.func_75776_a(3, (Goal)new JishinHoWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 200.0).func_233815_a_(Attributes.field_233821_d_, (double)0.29f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 0.3).func_233815_a_(Attributes.field_233824_g_, 1.5);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_226292_a_(Hand hand, boolean updateSelf) {
        super.func_226292_a_(hand, updateSelf);
    }
}

