/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.arlongpirates;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.MizuOsuAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.MizuShuryudanAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.MizuTaihoAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.MurasameAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.UchimizuAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ai.controllers.HumanoidSwimMoveController;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ClimbOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FactionHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.RunAwayFromTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.MizuOsuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.MizuShuryudanWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.MizuTaihoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.MurasameWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.UchimizuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;

public class ChewEntity
extends OPBossEntity<ChewEntity> {
    private static final UUID MIZU_SHURYUDAN_COOLDOWN_UUID = UUID.fromString("01fa80f8-1ce1-4456-8696-ed2a6ebd1468");
    private static final UUID MIZU_OSU_COOLDOWN_UUID = UUID.fromString("a5f2b30b-1526-4af7-a38b-ec1b0e1922a1");
    private static final UUID HARD_MIZU_TAIHO_COOLDOWN_UUID = UUID.fromString("beccb13e-c813-4d8e-b846-0b05b4ee7557");
    private static final UUID HARD_MURSAMAE_COOLDOWN_UUID = UUID.fromString("52afe78f-6be1-43be-89d5-12f3e405f9ff");
    private RevengeMeter revengeMeter;
    private MovementController groundMovementController;
    private MovementController waterMovementController;
    private NPCPhase<ChewEntity> groundPhase;
    private NPCPhase<ChewEntity> waterPhase;

    public ChewEntity(EntityType type, World world) {
        super(type, world);
    }

    public ChewEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.CHEW.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.revengeMeter = new RevengeMeter((LivingEntity)this, 100, 1);
        this.groundMovementController = new MovementController((MobEntity)this);
        this.waterMovementController = new HumanoidSwimMoveController((MobEntity)this);
        this.groundPhase = new SimplePhase<ChewEntity>("Ground Phase", this);
        this.waterPhase = new SimplePhase<ChewEntity>("Water Phase", this, this::startWaterPhaseEvent, this::stopWaterPhaseEvent);
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.FISHMAN);
        this.entityStats.setFightingStyle(ModValues.SNIPER);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.addTemporaryCrewMember(ModNPCGroups.ARLONG_PIRATES, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        UchimizuWrapperGoal uchimizuWrapper = new UchimizuWrapperGoal((MobEntity)this);
        ((UchimizuAbility)uchimizuWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 60.0f));
        MizuTaihoWrapperGoal mizuTaihoWrapper = new MizuTaihoWrapperGoal((MobEntity)this);
        MizuOsuWrapperGoal mizuOsuWrapper = new MizuOsuWrapperGoal((MobEntity)this);
        ((MizuOsuAbility)mizuOsuWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(MIZU_OSU_COOLDOWN_UUID, "Mizu Osu Cooldown Bonus", BonusOperation.ADD, -60.0f));
        MizuShuryudanWrapperGoal mizuShuryudanWrapper = new MizuShuryudanWrapperGoal((MobEntity)this);
        ((MizuShuryudanAbility)mizuShuryudanWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(MIZU_SHURYUDAN_COOLDOWN_UUID, "Mizu Shuryudan Cooldown Bonus", BonusOperation.ADD, -40.0f));
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(0, (Goal)new ClimbOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        Predicate<Entity> factionScope = ModEntityPredicates.getEnemyFactions((LivingEntity)this).and(ModEntityPredicates.IS_ENTITY_HARMLESS.negate());
        Predicate<Entity> invisibleCheck = factionScope.and(ModEntityPredicates.IS_INVISIBLE.negate());
        this.field_70715_bh.func_75776_a(1, (Goal)new FactionHurtByTargetGoal(this, factionScope, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, true, invisibleCheck));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, invisibleCheck));
        this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<FishmanPassiveBonusesAbility>((MobEntity)this, FishmanPassiveBonusesAbility.INSTANCE));
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 0.8f, true).setEarlyStop(this::isInRangeForAbilities));
        this.field_70714_bg.func_75776_a(3, (Goal)uchimizuWrapper);
        this.field_70714_bg.func_75776_a(4, (Goal)mizuShuryudanWrapper);
        this.field_70714_bg.func_75776_a(4, (Goal)mizuOsuWrapper);
        this.field_70714_bg.func_75776_a(4, (Goal)mizuTaihoWrapper);
        this.getPhaseManager().setPhase(this.groundPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(2.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
            this.field_70714_bg.func_75776_a(0, new RunAwayFromTargetGoal<ChewEntity>(this, 1.5, 100, 200));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 200.0f, 5.0f));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 70.0f, 2.25f));
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(3.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(5.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(300.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(4.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(5.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(12.0);
            ((MizuTaihoAbility)mizuTaihoWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_MIZU_TAIHO_COOLDOWN_UUID, "Hard Mizu Taiho Cooldown Bonus", BonusOperation.ADD, -100.0f));
            MurasameWrapperGoal murasameWrapper = new MurasameWrapperGoal((MobEntity)this);
            ((MurasameAbility)murasameWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> {
                comp.getBonusManager().addBonus(HARD_MURSAMAE_COOLDOWN_UUID, "Hard Murasame Cooldown Bonus", BonusOperation.ADD, -150.0f);
                comp.startCooldown((LivingEntity)this, 80.0f);
            });
            this.field_70714_bg.func_75776_a(0, new RunAwayFromTargetGoal<ChewEntity>(this, 1.7, 100, 100));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 100.0f, 4.0f));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 60.0f, 3.0f));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiImbuingWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)murasameWrapper);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233818_a_, 250.0).func_233815_a_(Attributes.field_233820_c_, 0.1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.getRevengeMeter().tick();
            if (this.func_70090_H()) {
                this.getPhaseManager().setPhase(this.waterPhase);
            } else {
                this.getPhaseManager().setPhase(this.groundPhase);
            }
        }
    }

    private boolean isInRangeForAbilities() {
        if (!GoalUtil.hasAliveTarget((MobEntity)this)) {
            return true;
        }
        return Math.abs(this.func_70032_d((Entity)this.func_70638_az())) < 30.0f;
    }

    private void startWaterPhaseEvent(ChewEntity entity) {
        this.field_70765_h = this.waterMovementController;
    }

    private void stopWaterPhaseEvent(ChewEntity entity) {
        this.field_70765_h = this.groundMovementController;
    }

    @Override
    public RevengeMeter getRevengeMeter() {
        return this.revengeMeter;
    }
}

