/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.buggypirates;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.DeadzoneRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalDamageDealtRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.ProjectileHitRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.TargetRunningAwayRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOverProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.carnivaltricks.IchirinZashiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.carnivaltricks.KajiOyajiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.carnivaltricks.KamikazeHyakkomaGekijoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.GeppoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.HiryuKaenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.OTatsumakiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.ShiShishiSonsonWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.swordsman.YakkodoriWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.DyeableModSwordItem;
import xyz.pixelatedw.mineminenomi.packets.server.SToggleAnimationPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CabajiEntity
extends OPBossEntity<CabajiEntity> {
    private static final byte NO_UNICYCLE_EVENT = 120;
    private NPCPhase<CabajiEntity> normalPhase = new SimplePhase<CabajiEntity>("Normal Phase", this);
    private NPCPhase<CabajiEntity> noUnicyclePhase = new SimplePhase<CabajiEntity>("No Unicycle Phase", this);
    private RevengeMeter damageTakenMeter = new RevengeMeter((LivingEntity)this, 200, 0);
    private boolean hasUnicycle = true;

    public CabajiEntity(EntityType type, World world) {
        super(type, world);
    }

    public CabajiEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.CABAJI.get(), challenge);
    }

    @Override
    public void initBoss() {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.HUMAN);
        this.entityStats.setFightingStyle(ModValues.SWORDSMAN);
        worldData.addTemporaryCrewMember(ModNPCGroups.BUGGY_PIRATES, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(2.5);
        this.func_184201_a(EquipmentSlotType.HEAD, ((Item)ModArmors.CABAJI_SCARF.get()).func_190903_i());
        this.func_184201_a(EquipmentSlotType.MAINHAND, ((DyeableModSwordItem)ModWeapons.CUTLASS.get()).func_190903_i());
        WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.playAnimation((LivingEntity)this, ModAnimations.RIDE_UNICYCLE, -1, true), (Entity)this);
        MobsHelper.addBasicNPCGoals(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.3, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new KajiOyajiWrapperGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new KamikazeHyakkomaGekijoWrapperGoal((MobEntity)this));
        this.normalPhase.addGoal(3, new IchirinZashiWrapperGoal((MobEntity)this));
        this.getPhaseManager().setPhase(this.normalPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.damageTakenMeter.addCheck(new PhysicalDamageDealtRevengeCheck());
            this.damageTakenMeter.addCheck(new ProjectileHitRevengeCheck(10));
            this.damageTakenMeter.addCheck(new DeadzoneRevengeCheck(10));
            this.damageTakenMeter.addCheck(new TargetRunningAwayRevengeCheck(10, 10.0f));
            this.entityStats.setDoriki(1000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.normalPhase.addGoal(0, new JumpOverProjectilesGoal((MobEntity)this, 150.0f, 1.5f));
            this.noUnicyclePhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 250.0f, 1.5f));
            this.noUnicyclePhase.addGoal(2, new ShiShishiSonsonWrapperGoal((MobEntity)this));
        } else {
            this.damageTakenMeter.addCheck(new PhysicalDamageDealtRevengeCheck(1.25f));
            this.damageTakenMeter.addCheck(new ProjectileHitRevengeCheck(25));
            this.damageTakenMeter.addCheck(new DeadzoneRevengeCheck(25));
            this.damageTakenMeter.addCheck(new TargetRunningAwayRevengeCheck(25, 10.0f));
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(6.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(12.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(4.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(16.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(250.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
            this.func_184201_a(EquipmentSlotType.OFFHAND, ((DyeableModSwordItem)ModWeapons.CUTLASS.get()).func_190903_i());
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiImbuingWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new YakkodoriWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new HiryuKaenWrapperGoal((MobEntity)this));
            this.normalPhase.addGoal(0, new JumpOverProjectilesGoal((MobEntity)this, 70.0f, 1.5f));
            this.noUnicyclePhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 200.0f, 3.0f));
            this.noUnicyclePhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 200.0f, 1.25f));
            this.noUnicyclePhase.addGoal(0, new GeppoWrapperGoal((MobEntity)this));
            this.noUnicyclePhase.addGoal(2, new ShiShishiSonsonWrapperGoal((MobEntity)this));
            this.noUnicyclePhase.addGoal(2, new OTatsumakiWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.31f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.damageTakenMeter.tick();
        if (!this.field_70170_p.field_72995_K && this.isDifficultyHardOrAbove() && this.normalPhase.isActive(this) && this.damageTakenMeter.isRevengeMaxed()) {
            this.getPhaseManager().setPhase(this.noUnicyclePhase);
            this.field_70170_p.func_72960_a((Entity)this, (byte)120);
            WyNetwork.sendToAllTrackingAndSelf(SToggleAnimationPacket.stopAnimation((LivingEntity)this, ModAnimations.RIDE_UNICYCLE), (Entity)this);
            this.hasUnicycle = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 120: {
                this.hasUnicycle = false;
            }
        }
        super.func_70103_a(id);
    }

    public boolean hasUnicycle() {
        return this.hasUnicycle;
    }
}

