/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.TakedownKickAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.ConcasseAbility;
import xyz.pixelatedw.mineminenomi.abilities.mandemontactics.DemonicDanceAbility;
import xyz.pixelatedw.mineminenomi.abilities.mandemontactics.DemonicDashAbility;
import xyz.pixelatedw.mineminenomi.abilities.mandemontactics.DemonicSmashAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.DeadzoneRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalHitRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.TakedownKickWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.AntiMannerKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.ConcasseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.PartyTableKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.mandemontactics.DemonicDanceWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.mandemontactics.DemonicDashWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.mandemontactics.DemonicSmashWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.KamieWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.RankyakuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.ShiganWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class GinEntity
extends OPBossEntity<GinEntity> {
    private static final UUID HARD_DEMON_DANCE_CHARGE_BONUS_UUID = UUID.fromString("8bde2608-50af-4a26-89a1-28e27ccdb933");
    private static final UUID HARD_DEMON_DASH_CHARGE_BONUS_UUID = UUID.fromString("f62f6b91-677f-4612-8464-f840fd7752a4");
    private static final UUID HARD_CONCASSE_COOLDOWN_BONUS_UUID = UUID.fromString("b88e2563-a90e-4976-b83e-1094b411b0cd");
    private static final UUID HARD_TAKEDOWN_KICK_COOLDOWN_BONUS_UUID = UUID.fromString("6f76d9e5-94ad-48bd-ab28-aae1860ea8f2");
    private RevengeMeter revengeMeter;
    private NPCPhase<GinEntity> normalPhase;
    private NPCPhase<GinEntity> emptyHandedPhase;

    public GinEntity(EntityType type, World world) {
        super(type, world);
    }

    public GinEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.GIN.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.revengeMeter = new RevengeMeter((LivingEntity)this, 100, 1);
        this.normalPhase = new SimplePhase<GinEntity>("Normal Phase", this);
        this.emptyHandedPhase = new SimplePhase<GinEntity>("Empty Handed Phase", this, this::startEmptyHandedPhaseEvent);
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.HUMAN);
        this.entityStats.setFightingStyle(ModValues.BRAWLER);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.addTemporaryCrewMember(ModNPCGroups.KRIEG_PIRATES, (LivingEntity)this);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.TONFA.get()));
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ModWeapons.TONFA.get()));
        this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(1.2);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(3.0);
        this.getRevengeMeter().addCheck(new PhysicalHitRevengeCheck(2));
        this.getRevengeMeter().addCheck(new DeadzoneRevengeCheck(10));
        DemonicDanceWrapperGoal demonicDanceWrapper = new DemonicDanceWrapperGoal((MobEntity)this);
        DemonicDashWrapperGoal demonicDashWrapper = new DemonicDashWrapperGoal((MobEntity)this);
        ((DemonicDashAbility)demonicDashWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            if (((DemonicDanceAbility)demonicDanceWrapper.getAbility()).isCharging() || ((DemonicDanceAbility)demonicDanceWrapper.getAbility()).isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        DemonicSmashWrapperGoal demonicSmashWrapper = new DemonicSmashWrapperGoal((MobEntity)this);
        ((DemonicSmashAbility)demonicSmashWrapper.getAbility()).addCanUseCheck((entity, ability) -> {
            if (((DemonicDanceAbility)demonicDanceWrapper.getAbility()).isCharging() || ((DemonicDanceAbility)demonicDanceWrapper.getAbility()).isContinuous()) {
                return AbilityUseResult.fail(null);
            }
            return AbilityUseResult.success();
        });
        ImprovedMeleeAttackGoal meleeAttackGoal = new ImprovedMeleeAttackGoal(this, 1.0, true);
        meleeAttackGoal.setEarlyStop(() -> ((DemonicDanceAbility)demonicDanceWrapper.getAbility()).isCharging());
        TakedownKickWrapperGoal takedownKickWrapper = new TakedownKickWrapperGoal((MobEntity)this);
        takedownKickWrapper.setMinDistance(5.0f);
        MobsHelper.addBasicNPCGoals(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 300.0f, 2.5f));
        this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 350.0f, 3.0f));
        this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)meleeAttackGoal);
        this.field_70714_bg.func_75776_a(2, (Goal)takedownKickWrapper);
        this.normalPhase.addGoal(2, demonicDanceWrapper);
        this.normalPhase.addGoal(2, demonicDashWrapper);
        this.normalPhase.addGoal(2, demonicSmashWrapper);
        this.getPhaseManager().setPhase(this.normalPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(2.0);
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(3.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(6.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(300.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(3.5);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(14.0);
            ((DemonicDanceAbility)demonicDanceWrapper.getAbility()).getComponent(ModAbilityKeys.CHARGE).ifPresent(comp -> comp.getMaxChargeBonusManager().addBonus(HARD_DEMON_DANCE_CHARGE_BONUS_UUID, "Hard Demon Dance Charge Bonus", BonusOperation.MUL, 0.5f));
            ((DemonicDashAbility)demonicDashWrapper.getAbility()).getComponent(ModAbilityKeys.CHARGE).ifPresent(comp -> comp.getMaxChargeBonusManager().addBonus(HARD_DEMON_DASH_CHARGE_BONUS_UUID, "Hard Demon Dash Charge Bonus", BonusOperation.MUL, 0.0f));
            ConcasseWrapperGoal concasseWrapper = new ConcasseWrapperGoal((MobEntity)this);
            ((ConcasseAbility)concasseWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_CONCASSE_COOLDOWN_BONUS_UUID, "Hard Concasse Cooldown Bonus", BonusOperation.ADD, 100.0f));
            ((TakedownKickAbility)takedownKickWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_TAKEDOWN_KICK_COOLDOWN_BONUS_UUID, "Hard Takedown Kick Cooldown Bonus", BonusOperation.ADD, -40.0f));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.normalPhase.addGoal(0, new BusoshokuHakiImbuingWrapperGoal((MobEntity)this));
            this.emptyHandedPhase.addGoal(0, new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.emptyHandedPhase.addGoal(2, new HakaiHoWrapperGoal((MobEntity)this));
            this.emptyHandedPhase.addGoal(2, new JishinHoWrapperGoal((MobEntity)this));
            this.emptyHandedPhase.addGoal(2, new ShiganWrapperGoal((MobEntity)this));
            this.emptyHandedPhase.addGoal(2, new AntiMannerKickCourseWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new PartyTableKickCourseWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)new RankyakuWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)new KamieWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)concasseWrapper);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.31f).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.1).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233825_h_, 5.0);
    }

    public boolean func_70652_k(Entity target) {
        if (target instanceof LivingEntity) {
            boolean hasTonfaInOff;
            LivingEntity livingTarget = (LivingEntity)target;
            boolean hasTonfaInMain = !this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() == ModWeapons.TONFA.get();
            boolean bl = hasTonfaInOff = !this.func_184592_cb().func_190926_b() && this.func_184592_cb().func_77973_b() == ModWeapons.TONFA.get();
            if (hasTonfaInMain || hasTonfaInOff) {
                ItemsHelper.stopShieldAndStartCooldown(livingTarget, 100);
                return super.func_70652_k(target);
            }
        }
        return super.func_70652_k(target);
    }

    private void startEmptyHandedPhaseEvent(GinEntity entity) {
        this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.getRevengeMeter().tick();
            if (!this.emptyHandedPhase.isActive(this) && this.func_184614_ca().func_190926_b()) {
                this.getPhaseManager().setPhase(this.emptyHandedPhase);
            }
        }
    }

    @Override
    public RevengeMeter getRevengeMeter() {
        return this.revengeMeter;
    }
}

