/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.RainTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderboltTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderstormTempo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.CoolBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.ThunderBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.WeatherBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.EntityCloud;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WeatherCloudEntity
extends EntityCloud {
    private static final int PARTICLE_RATE = 5;
    private static final int TICK_RATE = 50;
    private List<WeatherBallProjectile> weatherBalls = new ArrayList<WeatherBallProjectile>();
    private boolean charged = false;
    private boolean superCharged = false;
    private int particleTick = 5;
    private int updateTick = 50;
    private IAbilityData props;

    public WeatherCloudEntity(World world) {
        super(world);
        this.setLife(200);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            boolean canUseRain;
            boolean canUseThunderbolt;
            boolean canUseThunderstorm;
            if (--this.particleTick <= 0) {
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.WEATHER_CLOUD.get(), this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                if (this.charged || this.superCharged) {
                    WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CHARGED_WEATHER_CLOUD.get(), this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                }
                this.particleTick = 5;
            }
            if (--this.updateTick > 0) {
                return;
            }
            this.updateTick = 50;
            if (this.props == null) {
                this.props = AbilityDataCapability.get(this.getThrower());
            }
            if (this.getLife() <= 0 || this.getThrower() == null) {
                this.func_70106_y();
            }
            this.setLife(this.getLife() - 1);
            List thunderBallsList = this.weatherBalls.stream().filter(ThunderBallProjectile.class::isInstance).map(ThunderBallProjectile.class::cast).collect(Collectors.toList());
            List coolBallsList = this.weatherBalls.stream().filter(CoolBallProjectile.class::isInstance).map(CoolBallProjectile.class::cast).collect(Collectors.toList());
            int thunderBalls = thunderBallsList.size();
            int coolBalls = coolBallsList.size();
            ThunderstormTempo thunderstormTempo = this.props.getPassiveAbility(ThunderstormTempo.INSTANCE);
            boolean bl = canUseThunderstorm = thunderstormTempo != null && thunderstormTempo.canUse(this.getThrower()).isSuccess() && thunderBalls >= 5;
            if (canUseThunderstorm) {
                this.superCharged = true;
                thunderstormTempo.useTempo(this.getThrower(), this);
                return;
            }
            ThunderboltTempo thunderboltTempo = this.props.getPassiveAbility(ThunderboltTempo.INSTANCE);
            boolean bl2 = canUseThunderbolt = thunderboltTempo != null && thunderboltTempo.canUse(this.getThrower()).isSuccess() && thunderBalls > 0;
            if (canUseThunderbolt) {
                this.charged = true;
                thunderboltTempo.useTempo(this.getThrower(), this);
                return;
            }
            RainTempo rainTempo = this.props.getEquippedOrPassiveAbility(RainTempo.INSTANCE);
            boolean bl3 = canUseRain = rainTempo != null && rainTempo.canUse(this.getThrower()).isSuccess() && coolBalls >= 3;
            if (canUseRain) {
                rainTempo.use(this.getThrower());
                return;
            }
        }
    }

    public boolean isCharged() {
        return this.charged;
    }

    public boolean isSuperCharged() {
        return this.superCharged;
    }

    public void addWeatherBall(WeatherBallProjectile ball) {
        this.weatherBalls.add(ball);
    }
}

