/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.CyborgProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CoupDeVentProjectile
extends AbilityProjectileEntity {
    public CoupDeVentProjectile(EntityType type, World world) {
        super(type, world);
    }

    public CoupDeVentProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)CyborgProjectiles.COUP_DE_VENT.get(), world, player, ability);
        this.setDamage(50.0f);
        this.setPassThroughEntities();
        this.setMaxLife(15);
        this.setEntityCollisionSize(5.5);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity target) {
        double xPower = WyHelper.randomDouble() * 400.0;
        xPower = xPower >= 0.0 ? MathHelper.func_151237_a((double)xPower, (double)200.0, (double)400.0) : MathHelper.func_151237_a((double)xPower, (double)-400.0, (double)-200.0);
        double zPower = WyHelper.randomDouble() * 400.0;
        zPower = zPower >= 0.0 ? MathHelper.func_151237_a((double)zPower, (double)200.0, (double)400.0) : MathHelper.func_151237_a((double)zPower, (double)-400.0, (double)-200.0);
        target.func_195064_c(new EffectInstance((Effect)ModEffects.LAUNCHED.get(), 1200, 0));
        AbilityHelper.setDeltaMovement((Entity)target, xPower, 10.0, zPower);
        target.field_70143_R = 0.0f;
    }

    private void onTickEvent() {
        for (int i = 0; i < 25; ++i) {
            double offsetX = WyHelper.randomDouble() * 1.2;
            double offsetY = WyHelper.randomDouble() * 1.2;
            double offsetZ = WyHelper.randomDouble() * 1.2;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197624_q, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, -0.1);
            if (i % 5 != 0) continue;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_218419_B, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, -0.1);
        }
    }
}

