/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.doku;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.doku.HydraAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.DokuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class HydraProjectile
extends AbilityProjectileEntity {
    private boolean isDemonMode = false;

    public HydraProjectile(EntityType type, World world) {
        super(type, world);
    }

    public HydraProjectile(World world, LivingEntity player, boolean isDemonMode) {
        super((EntityType)DokuProjectiles.HYDRA.get(), world, player, HydraAbility.INSTANCE);
        this.setDamage(isDemonMode ? 30.0f : 20.0f);
        this.setEntityCollisionSize(1.75);
        this.setMaxLife(isDemonMode ? 40 : 30);
        this.setPassThroughEntities();
        this.isDemonMode = isDemonMode;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 400, this.isDemonMode ? 3 : 1));
        hitEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 400, this.isDemonMode ? 2 : 1));
        hitEntity.func_195064_c(new EffectInstance(Effects.field_76419_f, 400, this.isDemonMode ? 2 : 1));
        hitEntity.func_195064_c(new EffectInstance(Effects.field_76431_k, 400, this.isDemonMode ? 2 : 1));
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.isDemonMode);
    }

    @Override
    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.isDemonMode = buffer.readBoolean();
    }

    public boolean isDemonMode() {
        return this.isDemonMode;
    }
}

