/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hana;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateEntityOwnerPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class HanaHandsEntity
extends Entity {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(HanaHandsEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int warmupDelayTicks = 30;
    private int lifeTicks = 22;
    private float damage;
    private boolean sentEvent;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private LivingEntity target;
    private UUID casterUuid;
    private Ability parentAbility;

    public HanaHandsEntity(EntityType type, World world) {
        super(type, world);
    }

    public HanaHandsEntity(World world) {
        this((EntityType)HanaProjectiles.HANDS.get(), world);
    }

    public HanaHandsEntity(World world, Ability ability) {
        this(world);
        this.parentAbility = ability;
    }

    public void setCaster(LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster.func_110124_au();
    }

    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        this.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
    }

    public void setWarmup(int warmup) {
        this.warmupDelayTicks = warmup;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setClutch() {
        this.func_184212_Q().func_187227_b(TYPE, (Object)0);
    }

    public void setSlap() {
        this.func_184212_Q().func_187227_b(TYPE, (Object)1);
    }

    public int getHandsType() {
        return (Integer)this.func_184212_Q().func_187225_a(TYPE);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TYPE, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.warmupDelayTicks = compound.func_74762_e("Warmup");
        this.func_184212_Q().func_187227_b(TYPE, (Object)compound.func_74762_e("Type"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.casterUuid = compound.func_186857_a("OwnerUUID");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Warmup", this.warmupDelayTicks);
        compound.func_74768_a("Type", ((Integer)this.func_184212_Q().func_187225_a(TYPE)).intValue());
        if (this.casterUuid != null) {
            compound.func_186854_a("OwnerUUID", this.casterUuid);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                        double d1 = this.func_226278_cu_() + 0.05 + this.field_70146_Z.nextDouble();
                        double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                        double d3 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.field_70146_Z.nextDouble() * 0.3;
                        double d5 = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.3;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8 && this.target != null) {
                this.damage(this.target);
            }
            if (!this.sentEvent) {
                if (this.getCaster() != null) {
                    WyNetwork.sendToAllAround(new SUpdateEntityOwnerPacket(this.func_145782_y(), this.getCaster().func_145782_y()), this);
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
    }

    private void damage(LivingEntity target) {
        LivingEntity caster = this.getCaster();
        if (target.func_70089_S() && !target.func_190530_aW() && caster != null && target != caster) {
            this.parentAbility.getComponent(ModAbilityKeys.DAMAGE).ifPresent(comp -> comp.hurtTarget(caster, target, this.damage));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)ModSounds.SNAP_SFX.get(), this.func_184176_by(), 2.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float partialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - partialTicks) / 20.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

